#include <alloc.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <gettime.h>
#include <xneedmc.h>

#define BYTE unsigned char
#define WORD unsigned int
#define WHITE 251
#define LT_GREY 252
#define GREY 253
#define DK_GREY 254
#define BLACK 255
#define BaseX0 40
#define BaseY0 212
#define BaseX1 280
#define BaseY1 212
#define IncomingColor 236
#define OutgoingColor 235
#define MinLaunchHeight	200	//the lowest Y coordinate a missile will launch to (can't be bigger than than BaseY0 or BaseY1)
#define ExplDelay 1        //the bigger the #, the slower the course of explosion (must be a whole number ( >1 ) )
#define IncExplHgt 220		//the height at which the incoming missiles will detonate
#define BuildingHeight 220 //the height at which the buildings are placed (defines y-coord of center of building)
#define SplitHeight 50     //the height at which splitting missiles split
#define NumMissilesLostIfBaseHit 10
#define MaxIncoming 75
#define MaxBuzzBomb 15
#define BuzzBombXSpeed 1
#define BuzzBombYSpeed 1
#define BuzzBombXMaxInc 4
#define BuzzBombYMaxInc 4
#define MaxBuildings 50
#define SpriteFilenames {"cursor.spr\0","buzz0.spr","buzz1.spr","buzz2.spr","bldg0a.spr","bldg0b.spr","bldg1a.spr","bldg1b.spr","bldg2a.spr","bldg2b.spr","bldg3a.spr","bldg3b.spr","bldg4a.spr","bldg4b.spr","bldg5a.spr","bldg5b.spr","paused.spr","quit.spr","nomore\0"}
#define PointsMissile 100
#define PointsBuilding 3
#define PointsMislLeft 25
#define PointsBaseIntact 200
#define TextColor 234
#define ClockInterval 16
#define TRUE 1
#define FALSE 0

void Setup(void);
void CalibrateSpeed(void);
void InitNewGame(void);
void LoadPal(void);
void LoadSprites(void);
void LoadExplosions(void);
void LoadSounds(void);
void LoadScores(void);
void DefineLevels(void);
void InitLevel(void);
void Game(void);
void DrawScreen(void);
void DrawTrails(void);
void DoExplosions(void);
void DoIncomings(void);
void HitIncomings(void);
void DeleteIncoming(BYTE i);
void DeleteBuzzBomb(BYTE i);
void PlaceBuildings(BYTE Num);
void DrawBuildings(void);
void HitBuildings(void);
void UpdateScreenData(void);
void EndLevel(void);
void CountUp(WORD x,WORD y, WORD Page, BYTE Color, float Low, float High, float Inc);
void GameOver(void);
void NewHighScore(void);
void PlayAgain(void);
void LoadSBDriver(void);
//SB procedures
void LoadDriver(void);
char *LoadVOC(char *name);
int ContinueOutputVoice(void);
int PauseOutputVoice(void);
void StopVoiceProcess(void);
void OutputVoice(char *buffer);
void SetStatusWord(unsigned int *addr);
void SpeakerOnOff(int onoff);
void UninstallDriver(void);
int InitialiseDriver(void);
void SetIOAddr(int base);
void SetIOAddr(int base);
int GetVersion(void);


BYTE Abort=FALSE,
	Snd=TRUE,
	SpriteRefX[25],
	SpriteRefY[25],
	far *Sprite[25],
	NumSprites,
	ExplRefX[12],
	ExplRefY[12],
	far *Expl[12],
	NumExplSpr,
	NumTargets=0,
	NumExpl=0,
	NumIncoming=0,
	NumBuildings,
	NumBuildingsIntact,
	BuildingSprite[MaxBuildings],
	ScdryExpl[50],
	CurrentLevel=0,
	LevelFinished=TRUE,
	Exit=FALSE,
	Filename[20],
	HighScoreName[10][16],
	HighScoreLevel[10],
	HighScoreStage[10],
	MissileSplit[MaxIncoming],
	BuzzBombSprite[MaxBuzzBomb],
	GRating=FALSE,
	GameFinished=FALSE;
int TargetX[50],
	TargetY[50],
	ExplX[50],
	ExplY[50],
	BaseX[50],
	BaseY[50],
	IncomingStartX[MaxIncoming],
	IncomingStartY[MaxIncoming],
	BuildingX[MaxBuildings],
	BuildingY[MaxBuildings],
	BlastRadiusSqr[12],		//must have # of elements >= number of explosion frames
	BlastRadius[12],
	IncomingDestroyed,
	NumBuzzBomb=0,
	OverrideLevel=0,
	CurPos;						//for asm subroutine
float Score=0,
	HighScore[10],
	Standardz,z;  //speed not-so-constant
float TimeConst=0.48/ClockInterval;
float BuzzBombX[MaxBuzzBomb],
	BuzzBombY[MaxBuzzBomb],
	ExplFrame[50],
	NextIncoming=0,
	TrailX[50],
	TrailY[50],
	TrailXInc[50],
	TrailYInc[50],
	IncomingX[MaxIncoming],
	IncomingY[MaxIncoming],
	IncomingXInc[MaxIncoming],
	IncomingYInc[MaxIncoming],
	BuzzBombXInc[MaxBuzzBomb],
	BuzzBombYInc[MaxBuzzBomb];
	char far *driver_mem = NULL;			//for SB routines
void far (*driver)(void) = NULL;    //for SB routines
WORD status=0;
unsigned int Status=0;
char *Sound[10];
time_t begintime,
	endtime;

struct LevelStruct
	{
		int IncomingFreq,
			MissilesBase0,
			MissilesBase1,
			NumIncoming;
		float	IncomingSpeed;
			MissileSpeed;
		BYTE Background[20],
			Palette[20],
			BldgIntact,
			BldgDestroyed,
			MissileSplitProb,
			NumSplitWarheads,
			BuzzBombProb;
	} Level[50];

int main(int argc, char *argv[])
{
	BYTE HelpOnly=FALSE;
	int command=0;
	char n[10],nn=0,c;
	double timediff;

	while(++command<argc && *(argv[command]++)=='-')
	{
		c=*(argv[command]++);
		switch(c)
		{
			case 'q':
				Snd=FALSE;
				break;
			case '?','h':
				printf("Boom v1.666 Copyright (C) 1995 David Bond\n\n");
				printf("Command line options:\n");
				printf("-?,h   this screen\n");
				printf("-q     disable sound\n");
				printf("-g     G-rated mode\n");
				printf("\nNote:  to run with sound, you must have a 100% Sound Blaster compatible\n");
				printf("soundcard and the path to the CT-VOICE.DRV driver must be specified\n");
				printf("with SET SOUND=C:\\SB (if driver is in C:\\SB\\DRV).\n");
				printf("\nABSOLUTELY NO guarantees, expressed or implied, of ANYTHING.\n");
				HelpOnly=TRUE;
				break;
			case 'g':
				GRating=TRUE;
				break;
			case 'l':
				while(*argv[command]>='0' && *argv[command]<='9')
					n[nn++]=*(argv[command]++);
				sscanf(&n[0],"%i",&OverrideLevel);
				break;
			default:
				argv[command]-=2;
				printf("Invalid option: ");
				while(*argv[command]!=NULL)
					printf("%c",*(argv[command]++));
				printf("\n\nCommand line options:\n");
				printf("-?,h   this screen\n");
				printf("-q     disable sound\n");
				printf("-g     G-rated mode\n");
				printf("\nNote:  to run with sound, you must have a 100% Sound Blaster compatible\n");
				printf("soundcard and the path to the CT-VOICE.DRV driver must be specified\n");
				printf("with SET SOUND=C:\\SB (if driver is in C:\\SB\\DRV).\n");
				printf("\nABSOLUTELY NO guarantees, expressed or implied, of ANYTHING.\n");
				HelpOnly=TRUE;
				break;
		}
	}
	if(!HelpOnly)
	{
		Setup();
		while(!Exit)
		{
			InitNewGame();
			while(LevelFinished && !GameFinished)
			{
				LevelFinished=FALSE;
				Game();
				if(LevelFinished)
				{
					CurrentLevel++;
					EndLevel();
					if(!GameFinished)
						InitLevel();
				}
			}
			if(!Abort)
				GameOver();
			else
				PlayAgain();
		}
		if(Snd && !GRating)
		{
			OutputVoice(Sound[5]);
			while(Status);
		}
		//exit code
		x_mouse_remove();
		x_text_mode();
		//fix system clock, which was sped up in CalibrateSpeed()
		time(&endtime);
		RestoreInterval();
		timediff=difftime(endtime,begintime);
		endtime=1L+begintime+timediff/(double)ClockInterval;
		stime(&endtime);
		if(Snd)
		{
			UninstallDriver();
			free(Sound[1]);
			free(Sound[3]);
			free(Sound[5]);
			free(Sound[6]);
			free(Sound[7]);
			free(driver_mem);
		}
	}
	return(0);
}

void Setup(void)
{
	int i,j;

	TextMode();
	printf("DOS/4GW Protected Mode Run-time  Version 1.95\n");
	printf("Copyright (c) Rational Systems, Inc. 1990-1993\n\n");
	delay(1000);
	printf("Boom v1.666 Copyright (C) 1995 David Bond\n");
	if(Snd)
		LoadSBDriver();
	if(!MouseDriver())
	{
		printf("Mouse driver not found.\n");
		if(Snd)
			UninstallDriver();
		exit(1);
	}
	printf("\nInitializing 14Mb virtual memory...\n\n");
	delay(1250);

	printf("Initializing look-up tables...");
	GetCurPos();
	for(i=0;i<4097;i+=32)
	{
		SetCurPos();
		printf("%iK",i);
		delay(25);
	}
	printf("\n\nInitializing opponent AI neural network...\n");
	delay(1500);
	printf("CPU not fast enough for full neural net...running stripped version\n");
	delay(2500);
	x_set_mode(X_MODE_320x240,320);
	x_set_doublebuffer(240);
	x_text_init();
	NonVisual_Offs+=ScrnLogicalByteWidth*14;//fix so that mouse won't leave a trail
	x_mouse_init();
	MouseColor=LT_GREY;
	x_mouse_window(0,0,319,239);
	x_hide_mouse();
	randomize();
	strcpy(Filename,"title.pal\0");
	LoadPal();
	strcpy(Filename,"title.scr\0");
	DrawScreen();
	LoadScores();
	LoadExplosions();
	LoadSprites();
	CalibrateSpeed();
	if(Snd)
	{
		SetStatusWord(&Status);
		LoadSounds();
	}
}

void CalibrateSpeed(void)
{
	WORD StartTime;
	float x;

	StartTime=GetTime();
	while(GetTime()-StartTime<50)
	{
		x_line(0,0,319,239,0,HiddenPageOffs);
		x+=.5;
	}
	Standardz=565/x;
	time(&begintime);
	SetFastInterval();
	while(!MouseButtonStatus && !kbhit());
}

void InitNewGame(void)
{
	Score=0;
	Abort=FALSE;
	DefineLevels();
	LevelFinished=TRUE;
	GameFinished=FALSE;
	CurrentLevel=0;
	if(OverrideLevel!=0)
	{
		CurrentLevel=OverrideLevel;
		PlaceBuildings(5);
		OverrideLevel=0;
	}
	InitLevel();
}

void LoadScores(void)
{
	BYTE i;
	FILE *Handle;

/*	if((Handle=fopen("highscor.es\0","rb"))!=NULL)
	{
		for(i=0;i<10;i++)
		{
			fread(&HighScoreName[i][0],sizeof(BYTE),17,Handle);
			fread(&HighScoreLevel[i],sizeof(BYTE),1,Handle);
			fread(&HighScoreStage[i],sizeof(BYTE),1,Handle);
			fread(&HighScore[i],sizeof(float),1,Handle);
		}
		fclose(Handle);
	}
	else */
	{
		for(i=0;i<10;i++)
		{
			HighScore[i]=0;
			strcpy(HighScoreName[i],"Nobody      \0");
			HighScoreLevel[i]=1;
			HighScoreStage[i]=1;
		}
	}
}

void LoadPal(void)
{
	BYTE far *Buff;
	unsigned int *BytesRead;
	int Handle;

	if(!(Buff=(BYTE far *) farmalloc(768)))
	{
		x_text_mode();
		printf("Malloc failed in LoadPal().  Sorry.\n");
		exit(1);
	}
	_dos_open(Filename,O_RDONLY,&Handle);
	_dos_read(Handle,Buff,768,BytesRead);
	_dos_close(Handle);
	x_put_pal_raw(Buff,256,0);
	farfree(Buff);
}

void LoadSprites(void)
{
	BYTE Filenames[][15]=SpriteFilenames,
		far *SpriteSize,
		far *SpriteRef;
	unsigned int *BytesRead;
	int Handle;
	WORD i=0;

	SpriteSize=(BYTE far *) farmalloc(2);
	SpriteRef=(BYTE far *) farmalloc(2);
	while(strcmp(Filenames[i],"nomore\0")!=0)
	{
		_dos_open(Filenames[i],O_RDONLY,&Handle);
		_dos_read(Handle,SpriteSize,2,BytesRead);
		_dos_close(Handle);
		Sprite[i]=(BYTE far *) farmalloc(*SpriteSize**(SpriteSize+1)*4+4);
		_dos_open(Filenames[i],O_RDONLY,&Handle);
		_dos_read(Handle,Sprite[i],(*SpriteSize**(SpriteSize+1)*4+4),BytesRead);
		_dos_read(Handle,SpriteRef,2,BytesRead);
		SpriteRefX[i]=*SpriteRef;
		SpriteRefY[i]=*(SpriteRef+1);
		_dos_close(Handle);
		i++;
	}
	farfree(SpriteSize);
	farfree(SpriteRef);
	NumSprites=i;
}

void LoadExplosions(void)
{
	BYTE Filenames[][15]={"exp0.spr\0","exp1.spr\0","exp2.spr\0","exp3.spr\0","exp4.spr\0","exp5.spr\0","exp6.spr\0","exp7.spr\0","exp8.spr\0","exp9.spr\0","nomore\0"},
		far *SpriteSize,
		far *SpriteRef;
	unsigned int *BytesRead;
	int Handle;
	WORD i=0;

	SpriteSize=(BYTE far *) farmalloc(2);
	SpriteRef=(BYTE far *) farmalloc(2);
	while(strcmp(Filenames[i],"nomore\0")!=0)
	{
		_dos_open(Filenames[i],O_RDONLY,&Handle);
		_dos_read(Handle,SpriteSize,2,BytesRead);
		_dos_close(Handle);
		Expl[i]=(BYTE far *) farmalloc(*SpriteSize**(SpriteSize+1)*4+4);
		BlastRadiusSqr[i]=(*(SpriteSize+1)/2)*(*(SpriteSize+1)/2);		//half the height of the sprite squared
		BlastRadius[i]=*(SpriteSize+1)/2;
		_dos_open(Filenames[i],O_RDONLY,&Handle);
		_dos_read(Handle,Expl[i],(*SpriteSize**(SpriteSize+1)*4+4),BytesRead);
		_dos_read(Handle,SpriteRef,2,BytesRead);
		ExplRefX[i]=*SpriteRef;
		ExplRefY[i]=*(SpriteRef+1);
		_dos_close(Handle);
		i++;
	}
	farfree(SpriteSize);
	farfree(SpriteRef);
	NumExplSpr=i-1;
}

void DrawScreen()
{
	BYTE far *Buff;
	unsigned int *BytesRead;
	int Handle;
	WORD Inc;

	if(!(Buff=(BYTE far *) farmalloc(320*60+4)))
	{
		x_text_mode();
		printf("Malloc failed in DrawScreen().  Sorry.\n");
		exit(1);
	}
	_dos_open(Filename,O_RDONLY,&Handle);
	for(Inc=0;Inc<230;Inc+=60)
	{
		_dos_read(Handle,Buff,(320*60+4),BytesRead);
		x_put_pbm(0,Inc,HiddenPageOffs,Buff);
	}
	_dos_close(Handle);
	farfree(Buff);
	x_cp_vid_rect(0,0,320,240,0,0,HiddenPageOffs,NonVisual_Offs,320,320);
	x_page_flip(0,0);
	x_cp_vid_rect(0,0,320,240,0,0,VisiblePageOffs,HiddenPageOffs,320,320);
}

void InitLevel(void)
{
	BYTE i;

	x_rect_fill(0,0,320,240,VisiblePageOffs,0);
	if(CurrentLevel%3==0)
		PlaceBuildings(5);
	else if(NumBuildingsIntact<5)
	{
		do
			i=random(5);
		while(BuildingSprite[i]==Level[CurrentLevel].BldgIntact);
		BuildingSprite[i]=Level[CurrentLevel].BldgIntact;
		NumBuildingsIntact++;
	}
	strcpy(Filename,Level[CurrentLevel].Palette);
	LoadPal();
	strcpy(Filename,Level[CurrentLevel].Background);
	DrawScreen();
}

void Game(void)
{
	BYTE PressedLast=FALSE,
		c,
		KeyJustPressed=FALSE;
	WORD IncEndX,
		Time0,
		Time1;

	NumTargets=0;
	NumIncoming=0;
	NumBuzzBomb=0;
	NumExpl=0;
	if(Snd)
		while(Status);
	Time1=GetTime()-3;
	while(NumBuildingsIntact && LevelFinished==FALSE && !Exit)
	{
		Time0=GetTime();
		z=(float)(Time0-Time1)*TimeConst;
		if(KeyJustPressed)
		{
			z=0;
			KeyJustPressed=FALSE;
		}
		Time1=Time0;
		if((MouseButtonStatus==LEFT_PRESSED && Level[CurrentLevel].MissilesBase0>0 || MouseButtonStatus==RIGHT_PRESSED && Level[CurrentLevel].MissilesBase1>0) && PressedLast==FALSE)
		{
			if(MouseButtonStatus==LEFT_PRESSED)
			{
				BaseX[NumTargets]=BaseX0;
				BaseY[NumTargets]=BaseY0;
				Level[CurrentLevel].MissilesBase0--;
			}
			else if(MouseButtonStatus==RIGHT_PRESSED)
			{
				BaseX[NumTargets]=BaseX1;
				BaseY[NumTargets]=BaseY1;
				Level[CurrentLevel].MissilesBase1--;
			}
			TargetX[NumTargets]=MouseX;
			if(MouseY<MinLaunchHeight)
				TargetY[NumTargets]=MouseY;
			else
				TargetY[NumTargets]=MinLaunchHeight;
			TrailX[NumTargets]=(float)(BaseX[NumTargets]);
			TrailY[NumTargets]=(float)(BaseY[NumTargets]);
			TrailXInc[NumTargets]=((float)((TargetX[NumTargets]-BaseX[NumTargets]))/sqrt(((float) ( (TargetX[NumTargets]-BaseX[NumTargets]) ) *(float) ( (TargetX[NumTargets]-BaseX[NumTargets]) ) )+(float) ( (TargetY[NumTargets]-BaseY[NumTargets]) ) *(float) ( (TargetY[NumTargets]-BaseY[NumTargets]) ) ) ) * Level[CurrentLevel].MissileSpeed;
			TrailYInc[NumTargets]=((float)((TargetY[NumTargets]-BaseY[NumTargets]))/sqrt(((float) ( (TargetX[NumTargets]-BaseX[NumTargets]) ) *(float) ( (TargetX[NumTargets]-BaseX[NumTargets]) ) )+(float) ( (TargetY[NumTargets]-BaseY[NumTargets]) ) *(float) ( (TargetY[NumTargets]-BaseY[NumTargets]) ) ) ) * Level[CurrentLevel].MissileSpeed;
			NumTargets++;
			PressedLast=TRUE;
		}
		if(MouseButtonStatus==FALSE)
			PressedLast=FALSE;
		NextIncoming+=z;
		if(NextIncoming>Level[CurrentLevel].IncomingFreq)
		{
			NextIncoming=0;
			Level[CurrentLevel].NumIncoming--;
			if(Level[CurrentLevel].NumIncoming>=0)
			{
				if(random(100)>=Level[CurrentLevel].BuzzBombProb) //not a buzz bomb
				{
					IncEndX=random(320);
					IncomingX[NumIncoming]=random(320);
					IncomingY[NumIncoming]=0;
					IncomingStartX[NumIncoming]=(int)(IncomingX[NumIncoming]);
					IncomingStartY[NumIncoming]=0;
					IncomingXInc[NumIncoming]=((float)((IncEndX-IncomingX[NumIncoming]))/sqrt(((float) ( (IncEndX-IncomingX[NumIncoming]) ) *(float) ( (IncEndX-IncomingX[NumIncoming]) ) )+(float) ( (IncExplHgt-IncomingY[NumIncoming]) ) *(float) ( (IncExplHgt-IncomingY[NumIncoming]) ) ) ) * Level[CurrentLevel].IncomingSpeed;
					IncomingYInc[NumIncoming]=((float)((IncExplHgt-IncomingY[NumIncoming]))/sqrt(((float) ( (IncEndX-IncomingX[NumIncoming]) ) *(float) ( (IncEndX-IncomingX[NumIncoming]) ) )+(float) ( (IncExplHgt-IncomingY[NumIncoming]) ) *(float) ( (IncExplHgt-IncomingY[NumIncoming]) ) ) ) * Level[CurrentLevel].IncomingSpeed;
					if(random(100)>=Level[CurrentLevel].MissileSplitProb) //then missile won't split
						MissileSplit[NumIncoming]=FALSE;
					else //missile will split
						MissileSplit[NumIncoming]=TRUE;
					NumIncoming++;
				}
				else //no missile;  buzz bomb instead
				{
					BuzzBombX[NumBuzzBomb]=random(280)+20;
					BuzzBombY[NumBuzzBomb]=0;
					BuzzBombXInc[NumBuzzBomb]=0;
					BuzzBombYInc[NumBuzzBomb]=1.2;
					BuzzBombSprite[NumBuzzBomb]=1;
					NumBuzzBomb++;
				}
			}
		}
		if(Level[CurrentLevel].NumIncoming<0 && NumIncoming==0 && NumBuzzBomb==0 && NumExpl==0)
		{
			LevelFinished=TRUE;
			x_cp_vid_rect(0,0,320,240,0,0,NonVisual_Offs,HiddenPageOffs,320,320);
			HitBuildings();
			DrawBuildings();
			HitIncomings();
			DoIncomings();
			DrawTrails();
			UpdateScreenData();
			DoExplosions();
			x_page_flip(0,0);
			delay(500*ClockInterval);
		}
		else
		{
			HitBuildings();
			DrawBuildings();
			HitIncomings();
			DoIncomings();
			DrawTrails();
			UpdateScreenData();
			DoExplosions();
			//place cursor
			x_put_masked_pbm_clipxy(MouseX-SpriteRefX[0],MouseY-SpriteRefY[0],HiddenPageOffs,Sprite[0]);
			x_page_flip(0,0);
			x_cp_vid_rect(0,0,320,240,0,0,NonVisual_Offs,HiddenPageOffs,320,320);
		}
		if(kbhit())
		{
			c=getch();
			if(c=='p' || c=='P')
			{
				KeyJustPressed=TRUE;
				x_put_masked_pbm(160-SpriteRefX[16],120-SpriteRefY[16],VisiblePageOffs,Sprite[16]);
				getch();
			}
			if(c==27 || c=='q')
			{
				KeyJustPressed=TRUE;
				x_put_masked_pbm(160-SpriteRefX[17],120-SpriteRefY[17],VisiblePageOffs,Sprite[17]);
				c=getch();
				if(c=='Y' || c =='y')
				{
					Exit=TRUE;
					Abort=TRUE;
				}
			}
		}
	}
}

void DrawTrails(void)
{
	BYTE i;

	for(i=0;i<NumTargets;i++)
	{
		TrailX[i]+=TrailXInc[i]*z;
		TrailY[i]+=TrailYInc[i]*z;
		if(TrailX[i]<0)
			TrailX[i]=0;
		x_line(BaseX[i],BaseY[i],(int)(TrailX[i]),(int)(TrailY[i]),OutgoingColor,HiddenPageOffs);
	}
	for(i=0;i<NumTargets;i++)
		if((int)(TrailY[i])<TargetY[i])
		{
			//make explosion at end of trail
			ExplX[NumExpl]=TrailX[i];
			ExplY[NumExpl]=TrailY[i];
			ExplFrame[NumExpl]=0;
			ScdryExpl[NumExpl]=FALSE;
			NumExpl++;
			//get rid of old trail data and reorganize array
			BaseX[i]=BaseX[NumTargets-1];
			BaseY[i]=BaseY[NumTargets-1];
			TrailX[i]=TrailX[NumTargets-1];
			TrailY[i]=TrailY[NumTargets-1];
			TrailXInc[i]=TrailXInc[NumTargets-1];
			TrailYInc[i]=TrailYInc[NumTargets-1];
			TargetX[i]=TargetX[NumTargets-1];
			TargetY[i]=TargetY[NumTargets-1];
			NumTargets--;
			i--;
		}
}

void DoExplosions(void)
{
	BYTE i;
	int Frame;

	for(i=0;i<NumExpl;i++)
	{
		if(ExplFrame[i]==0 && Snd)
		{
			StopVoiceProcess();
			OutputVoice(Sound[1]);
		}
		Frame=(int)ExplFrame[i]/ExplDelay;
		x_put_masked_pbm_clipxy(ExplX[i]-ExplRefX[Frame],ExplY[i]-ExplRefY[Frame],HiddenPageOffs,Expl[Frame]);
		ExplFrame[i]+=z;
		if((int)ExplFrame[i]/ExplDelay>NumExplSpr)
		{
			ExplX[i]=ExplX[NumExpl-1];
			ExplY[i]=ExplY[NumExpl-1];
			ExplFrame[i]=ExplFrame[NumExpl-1];
			NumExpl--;
			i--;
		}
	}
}

void DoIncomings(void)
{
	BYTE i,
		j;

	for(i=0;i<NumIncoming;i++)
	{
		IncomingX[i]+=IncomingXInc[i]*z;
		IncomingY[i]+=IncomingYInc[i]*z;
		x_line(IncomingStartX[i],IncomingStartY[i],(int)(IncomingX[i]),(int)(IncomingY[i]),IncomingColor,HiddenPageOffs);
		//Missile splits
		if(IncomingY[i]>SplitHeight && MissileSplit[i]==TRUE && IncomingYInc[i]>0)
		{
			IncomingXInc[i]=0;
			IncomingYInc[i]=0;
			for(j=0;j<Level[CurrentLevel].NumSplitWarheads;j++)
			{
				WORD IncEndX;
				IncEndX=random(320);
				IncomingX[NumIncoming]=IncomingX[i];
				IncomingY[NumIncoming]=IncomingY[i];
				IncomingStartX[NumIncoming]=(int)(IncomingX[i]);
				IncomingStartY[NumIncoming]=(int)(IncomingY[i]);
				IncomingXInc[NumIncoming]=((float)((IncEndX-IncomingX[NumIncoming]))/sqrt(((float) ( (IncEndX-IncomingX[NumIncoming]) ) *(float) ( (IncEndX-IncomingX[NumIncoming]) ) )+(float) ( (IncExplHgt-IncomingY[NumIncoming]) ) *(float) ( (IncExplHgt-IncomingY[NumIncoming]) ) ) ) * Level[CurrentLevel].IncomingSpeed;
				IncomingYInc[NumIncoming]=((float)((IncExplHgt-IncomingY[NumIncoming]))/sqrt(((float) ( (IncEndX-IncomingX[NumIncoming]) ) *(float) ( (IncEndX-IncomingX[NumIncoming]) ) )+(float) ( (IncExplHgt-IncomingY[NumIncoming]) ) *(float) ( (IncExplHgt-IncomingY[NumIncoming]) ) ) ) * Level[CurrentLevel].IncomingSpeed;
				MissileSplit[NumIncoming]=FALSE;
				NumIncoming++;
			}
		}
	}
	for(i=0;i<NumIncoming;i++)
		if((int)(IncomingY[i])>IncExplHgt)
		{
			DeleteIncoming(i);
			NumIncoming--;
			i--;
		}
	//buzz bombs
	for(i=0;i<NumBuzzBomb;i++)
	{
		BuzzBombX[i]+=BuzzBombXInc[i]*z;
		BuzzBombY[i]+=BuzzBombYInc[i]*z;
		if(BuzzBombX[i]<10)
		{
			BuzzBombX[i]=10;
			BuzzBombXInc[i]=2;
		}
		if(BuzzBombX[i]>310)
		{
			BuzzBombX[i]=310;
			BuzzBombXInc[i]=-2;
		}
		BuzzBombSprite[i]++;
		if(BuzzBombSprite[i]>3)
			BuzzBombSprite[i]=1;
		x_put_masked_pbm_clipxy((int)BuzzBombX[i]-SpriteRefX[BuzzBombSprite[i]],(int)BuzzBombY[i]-SpriteRefY[BuzzBombSprite[i]],HiddenPageOffs,Sprite[BuzzBombSprite[i]]);

		BuzzBombXInc[i]+=((random(101)/50)*(random(3)-1))*z;
		if(BuzzBombXInc[i]>5)
			BuzzBombXInc[i]=-2;
		if(BuzzBombXInc[i]<-5)
			BuzzBombXInc[i]=2;


		if(BuzzBombY[i]>IncExplHgt)
		{
			DeleteBuzzBomb(i);
			NumBuzzBomb--;
			i--;
		}
	}
}

void HitIncomings(void)
{
	BYTE i,
		j;

	for(i=0;i<NumIncoming;i++)
		for(j=0;j<NumExpl;j++)
			if(BlastRadiusSqr[((int)ExplFrame[j]/ExplDelay)]>=	((float) ((ExplX[j]-IncomingX[i])) *(float) ((ExplX[j]-IncomingX[i])))+(float) ((ExplY[j]-IncomingY[i])) *(float) ((ExplY[j]-IncomingY[i]))   && IncomingYInc[i]!=0)
			{
				DeleteIncoming(i);
				NumIncoming--;
				i--;
				Score+=PointsMissile;
			}
	for(i=0;i<NumBuzzBomb;i++)
		for(j=0;j<NumExpl;j++)
			if(BlastRadiusSqr[((int)ExplFrame[j]/ExplDelay)]>=	((float) ((ExplX[j]-BuzzBombX[i])) *(float) ((ExplX[j]-BuzzBombX[i])))+(float) ((ExplY[j]-BuzzBombY[i])) *(float) ((ExplY[j]-BuzzBombY[i]))   )
			{
				DeleteBuzzBomb(i);
				NumBuzzBomb--;
				i--;
				Score+=PointsMissile;
			}

}

void DeleteIncoming(BYTE i)
{
	BYTE j,
		k,
		StillActive;

	//make explosion at end of trail
	ExplX[NumExpl]=IncomingX[i];
	ExplY[NumExpl]=IncomingY[i];
	ExplFrame[NumExpl]=0;
	ScdryExpl[NumExpl]=FALSE;
	NumExpl++;
	//get rid of old trail data and reorganize array
	IncomingX[i]=IncomingX[NumIncoming-1];
	IncomingY[i]=IncomingY[NumIncoming-1];
	IncomingXInc[i]=IncomingXInc[NumIncoming-1];
	IncomingYInc[i]=IncomingYInc[NumIncoming-1];
	IncomingStartX[i]=IncomingStartX[NumIncoming-1];
	IncomingStartY[i]=IncomingStartY[NumIncoming-1];
	MissileSplit[i]=MissileSplit[NumIncoming-1];
	//check if upper branch of a split warhead is isolated (no active missiles attached to it) and if so, delete it
	for(j=0;j<NumIncoming-1;j++)
	{
		if(MissileSplit[j]==TRUE)
		{
			StillActive=FALSE;
			for(k=0;k<NumIncoming-1;k++)
			{
				if(IncomingStartX[k]==(int)IncomingX[j] && IncomingStartY[k]==(int)IncomingY[j] || IncomingYInc[j]!=0)
					StillActive=TRUE;
			}
			if(!StillActive)
			{
				NumIncoming--;
				IncomingX[j]=IncomingX[NumIncoming];
				IncomingY[j]=IncomingY[NumIncoming];
				IncomingXInc[j]=IncomingXInc[NumIncoming];
				IncomingYInc[j]=IncomingYInc[NumIncoming];
				IncomingStartX[j]=IncomingStartX[NumIncoming];
				IncomingStartY[j]=IncomingStartY[NumIncoming];
				MissileSplit[j]=MissileSplit[NumIncoming];
			}
		}
	}
}

void DeleteBuzzBomb(BYTE i)
{
	//make explosion at end of trail
	ExplX[NumExpl]=BuzzBombX[i];
	ExplY[NumExpl]=BuzzBombY[i];
	ExplFrame[NumExpl]=0;
	ScdryExpl[NumExpl]=FALSE;
	NumExpl++;
	//get rid of old trail data and reorganize array
	BuzzBombX[i]=BuzzBombX[NumBuzzBomb-1];
	BuzzBombY[i]=BuzzBombY[NumBuzzBomb-1];
	BuzzBombXInc[i]=BuzzBombXInc[NumBuzzBomb-1];
	BuzzBombYInc[i]=BuzzBombYInc[NumBuzzBomb-1];
}

void PlaceBuildings(BYTE Num)
{
	BYTE i,
		j;

	NumBuildings=NumBuildingsIntact=Num;
	for(i=0;i<NumBuildings;i++)
	{
		BuildingX[i]=i*45+72;
		BuildingY[i]=random(5)+BuildingHeight;
		BuildingSprite[i]=Level[CurrentLevel].BldgIntact;
	}
}

void DrawBuildings(void)
{
	BYTE i;

	for(i=0;i<NumBuildings;i++)
		x_put_masked_pbm_clipxy(BuildingX[i]-SpriteRefX[BuildingSprite[i]],BuildingY[i]-SpriteRefY[BuildingSprite[i]],HiddenPageOffs,Sprite[BuildingSprite[i]]);
}

void HitBuildings(void)
{
	BYTE i,
		j;
	int Frame;

	for(j=0;j<NumExpl;j++)
	{
		Frame=(int)ExplFrame[j]/ExplDelay;
		for(i=0;i<NumBuildings;i++)
		{
			if(BuildingSprite[i]==Level[CurrentLevel].BldgIntact
				&&
				ScdryExpl[j]==FALSE
				&&
				BuildingY[i]-SpriteRefY[BuildingSprite[i]] <= ExplY[j]+BlastRadius[Frame]
				&&
				BuildingY[i]+SpriteRefY[BuildingSprite[i]] >= ExplY[j]-BlastRadius[Frame]
				&&
				BuildingX[i]+SpriteRefX[BuildingSprite[i]] >= ExplX[j]-BlastRadius[Frame]
				&&
				BuildingX[i]-SpriteRefX[BuildingSprite[i]] <= ExplX[j]+BlastRadius[Frame]
				)
			{
				BuildingSprite[i]=Level[CurrentLevel].BldgDestroyed;
				ExplX[NumExpl]=BuildingX[i];
				ExplY[NumExpl]=BuildingY[i];
				ExplFrame[NumExpl]=(float)(3*ExplDelay);
				ScdryExpl[NumExpl]=TRUE;
				NumExpl++;
				NumBuildingsIntact--;
			}
		}
		if(BaseX0 >= ExplX[j]-BlastRadius[(ExplFrame[j]/ExplDelay)]
			&&
			BaseX0 <= ExplX[j]+BlastRadius[(ExplFrame[j]/ExplDelay)]
			&&
			BaseY0 <= ExplY[j]+BlastRadius[(ExplFrame[j]/ExplDelay)]
			&&
			BaseY0 >= ExplY[j]-BlastRadius[(ExplFrame[j]/ExplDelay)]
			&&
			ScdryExpl[j]==FALSE)
		{
			ScdryExpl[j]=TRUE;
			Level[CurrentLevel].MissilesBase0-=NumMissilesLostIfBaseHit;
			if(Level[CurrentLevel].MissilesBase0<0)
				Level[CurrentLevel].MissilesBase0=0;
		}
		if(BaseX1 >= ExplX[j]-BlastRadius[(ExplFrame[j]/ExplDelay)]
			&&
			BaseX1 <= ExplX[j]+BlastRadius[(ExplFrame[j]/ExplDelay)]
			&&
			BaseY1 <= ExplY[j]+BlastRadius[(ExplFrame[j]/ExplDelay)]
			&&
			BaseY1 >= ExplY[j]-BlastRadius[(ExplFrame[j]/ExplDelay)]
			&&
			ScdryExpl[j]==FALSE)
		{
			ScdryExpl[j]=TRUE;
			Level[CurrentLevel].MissilesBase1-=NumMissilesLostIfBaseHit;
			if(Level[CurrentLevel].MissilesBase1<0)
				Level[CurrentLevel].MissilesBase1=0;
		}
	}
}

void UpdateScreenData(void)
{
	x_printf(BaseX0-8,1,HiddenPageOffs,TextColor,"%i",Level[CurrentLevel].MissilesBase0);
	x_printf(BaseX1-8,1,HiddenPageOffs,TextColor,"%i",Level[CurrentLevel].MissilesBase1);
	x_printf(140,1,HiddenPageOffs,TextColor,"%.0f",Score);
}

void EndLevel(void)
{
	float OldScore=Score;
	BYTE TColor=107;

	x_rect_fill(0,0,320,240,VisiblePageOffs,0);
	strcpy(Filename,"title.pal");
	LoadPal();
	strcpy(Filename,"title.scr");
	DrawScreen();
	x_printf(55,70,VisiblePageOffs,TColor,"Level %i, Stage %i complete!",(CurrentLevel-1)/3+1,(CurrentLevel-1)%3+1);
	x_printf(25,90,VisiblePageOffs,TColor,"Points:");
	x_printf(230,90,VisiblePageOffs,TColor,"%9.0f",Score);
	if(Snd)
	{
		StopVoiceProcess();
		OutputVoice(Sound[7]);
		while(Status);
	}
	x_printf(25,120,VisiblePageOffs,TColor,"Missiles left:");
	x_printf(230,120,VisiblePageOffs,TColor,"%i",Level[CurrentLevel-1].MissilesBase0+Level[CurrentLevel-1].MissilesBase1);
	if(Snd)
	{
		StopVoiceProcess();
		OutputVoice(Sound[7]);
		while(Status);
	}
	Score+=(float)((Level[CurrentLevel-1].MissilesBase0+Level[CurrentLevel-1].MissilesBase1)*PointsMislLeft);
	CountUp(230,120,VisiblePageOffs,TColor,0,(float)(Score-OldScore),54);
	x_printf(25,140,VisiblePageOffs,TColor,"Bases left:");
	x_printf(230,140,VisiblePageOffs,TColor,"%i",NumBuildingsIntact);
	if(Snd)
	{
		StopVoiceProcess();
		OutputVoice(Sound[7]);
		while(Status);
	}
	CountUp(230,140,VisiblePageOffs,TColor,0,(float)(NumBuildingsIntact*PointsBaseIntact),54);
	Score+=(float)(NumBuildingsIntact*PointsBaseIntact);
	x_printf(25,160,VisiblePageOffs,TColor,"Total:");
	x_printf(230,160,VisiblePageOffs,TColor,"%9.0f",Score);
	if(Snd)
	{
		StopVoiceProcess();
		OutputVoice(Sound[7]);
		while(Status);
	}
	x_printf(65,180,VisiblePageOffs,TColor,"Press a key to continue");
	while(!(kbhit() || MouseButtonStatus==LEFT_PRESSED));
	if(kbhit())
		getch();
	if(CurrentLevel==18)
		GameFinished=TRUE;
}

void CountUp(WORD x,WORD y, WORD Page, BYTE Color, float Low, float High, float Inc)
{
	BYTE i,
		far *Buff;
	float Num;

	if(Snd)
		StopVoiceProcess();
	Buff=(BYTE far *) farmalloc(8*22*4+4);
	if(!Buff)
		x_printf(10,10,VisiblePageOffs,Color,"Malloc failed in CountUp().  Sorry.");
	x_get_pbm(x,y,22,8,Page,Buff);
	for(Num=Low;Num<High;Num+=Inc)
	{
		x_put_pbm(x,y,Page,Buff);
		x_printf(x,y,Page,Color,"%9.0f",Num);
		if(Snd)
		{
			delay(10*ClockInterval);
			OutputVoice(Sound[6]);
			delay(10*ClockInterval);
			OutputVoice(Sound[6]);
			delay(10*ClockInterval);
			OutputVoice(Sound[6]);
			delay(10*ClockInterval);
			OutputVoice(Sound[6]);
		}
		else
			delay(40*ClockInterval);
	}
	x_put_pbm(x,y,Page,Buff);
	farfree(Buff);
	x_printf(x,y,Page,Color,"%9.0f",High);
	if(Snd)
	{
		StopVoiceProcess();
		OutputVoice(Sound[7]);
		while(Status);
	}
}

void GameOver(void)
{
	BYTE i;

	z=Standardz;
	if(!GameFinished)
	{
		for(i=0;i<25;)
		{
			if(i==0 || ExplFrame[NumExpl-1]/ExplDelay>1)
			{
				ExplX[NumExpl]=random(299);
				ExplY[NumExpl]=random(210);
				ExplFrame[NumExpl]=0;
				ScdryExpl[NumExpl]=FALSE;
				NumExpl++;
				i++;
			}
			x_cp_vid_rect(0,0,320,240,0,0,NonVisual_Offs,HiddenPageOffs,320,320);
			DrawBuildings();
			DoExplosions();
			x_page_flip(0,0);
		}
		while(Status || NumExpl>0)
		{
			x_cp_vid_rect(0,0,320,240,0,0,NonVisual_Offs,HiddenPageOffs,320,320);
			DrawBuildings();
			DoExplosions();
			x_page_flip(0,0);
		}
		x_cp_vid_rect(0,0,320,240,0,0,NonVisual_Offs,HiddenPageOffs,320,320);
		DrawBuildings();
		x_page_flip(0,0);
		if(Snd && !GRating)
		{
			OutputVoice(Sound[3]);
			while(Status);
			OutputVoice(Sound[5]);
			while(Status);
		}
		delay(500*ClockInterval);
	}
	x_rect_fill(0,0,320,240,VisiblePageOffs,0);
	strcpy(Filename,"gameover.pal");
	LoadPal();
	strcpy(Filename,"gameover.scr");
	DrawScreen();
	if(GameFinished)
	{
		x_printf(10,10,VisiblePageOffs,GREY,"Wow man, you've finished the game!");
		x_printf(10,20,VisiblePageOffs,GREY,"You kick ass!");
	}
	x_printf(10,50,VisiblePageOffs,WHITE,"Your final score is %.0f points.",Score);
	if(Score>HighScore[9])
		NewHighScore();
	x_printf(30,110,VisiblePageOffs,WHITE,"Top Scorers:");
	x_printf(35,120,VisiblePageOffs,WHITE,"NAME");
	x_printf(144,120,VisiblePageOffs,WHITE,"LEVEL");
	x_printf(194,120,VisiblePageOffs,WHITE,"STAGE");
	x_printf(260,120,VisiblePageOffs,WHITE,"SCORE");
	for(i=0;i<10;i++)
	{
		x_printf(5,130+i*10,VisiblePageOffs,WHITE,"%i",i+1);
		x_printf(35,130+i*10,VisiblePageOffs,GREY,"%s",HighScoreName[i]);
		if(HighScoreLevel[i]==69)
			x_printf(136,130+i*10,VisiblePageOffs,WHITE,"finished game");
		else
		{
			x_printf(160,130+i*10,VisiblePageOffs,GREY,"%i",HighScoreLevel[i]);
			x_printf(210,130+i*10,VisiblePageOffs,GREY,"%i",HighScoreStage[i]);
		}
		x_printf(230,130+i*10,VisiblePageOffs,GREY,"%9.0f",HighScore[i]);
	}
	x_printf(75,230,VisiblePageOffs,WHITE,"Press a key to continue");
	while(!(kbhit() || MouseButtonStatus==LEFT_PRESSED));
	if(kbhit())
		getch();
	PlayAgain();
}

void NewHighScore(void)
{
	BYTE i,
		j=0,
		KeyPress,
		Place=0,
		far *Buff;

	Buff=(BYTE far *) farmalloc(8*30*4+4);
	x_get_pbm(170,80,30,8,VisiblePageOffs,Buff);
	x_printf(10,60,VisiblePageOffs,WHITE,"Congratulations!");
	x_printf(10,70,VisiblePageOffs,WHITE,"You have a new high score!");
	x_printf(10,80,VisiblePageOffs,WHITE,"What is your name?");
	while(Score<=HighScore[j]) j++;
	for(i=9;i>j;i--)
	{
		HighScore[i]=HighScore[i-1];
		strcpy(HighScoreName[i],HighScoreName[i-1]);
		HighScoreLevel[i]=HighScoreLevel[i-1];
	}
	HighScore[j]=Score;
	HighScoreLevel[j]=CurrentLevel/3+1;
	if(GameFinished)
		HighScoreLevel[j]=69;
	HighScoreStage[j]=CurrentLevel%3+1;
	strcpy(HighScoreName[j],"               \0");
	KeyPress=getch();
	while(KeyPress!=13 && KeyPress!=27)
	{
		if(KeyPress==8 && Place>0)
		{
			if(Place==11)
				HighScoreName[j][Place]=' ';
			Place--;
			HighScoreName[j][Place]=' ';
		}
		else if(KeyPress>32 && KeyPress<127)
		{
			HighScoreName[j][Place]=KeyPress;
			Place++;
			if(Place>11)
				Place--;
		}
	x_put_pbm(170,80,VisiblePageOffs,Buff);
	x_printf(170,80,VisiblePageOffs,GREY,"%s",HighScoreName[j]);
	KeyPress=getch();
	}
	farfree(Buff);
}

void PlayAgain(void)
{
	BYTE Choice;

	Exit=FALSE;
	x_rect_fill(0,0,320,240,VisiblePageOffs,0);
	strcpy(Filename,"playagen.pal");
	LoadPal();
	strcpy(Filename,"playagen.scr");
	DrawScreen();
	do
	{
		Choice=getch();
	} while (Choice!='Y' && Choice!='y' && Choice !='N' && Choice !='n');
	if(Choice=='N' || Choice =='n')
		Exit=TRUE;
}

void LoadSBDriver(void)
{
	LoadDriver();
	if(driver == NULL)
	{
		Snd=FALSE;
		printf("Could not load CT-VOICE.DRV\n");
	}
	if(Snd)
		if(InitialiseDriver())
		{
			Snd=FALSE;
			printf("Could not initialise CT-VOICE.DRV\n");
		}
	if(Snd)
		SetStatusWord(&status);
}

void LoadSounds(void)
{
	Sound[1]=LoadVOC("expl.voc");
	Sound[3]=LoadVOC("end0.voc");
	Sound[5]=LoadVOC("end2.voc");
	Sound[6]=LoadVOC("count.voc");
	Sound[7]=LoadVOC("whistle.voc");
}

//***************************************************************************
//***************************************************************************
//***************************************************************************
//SB procedures from here on down
//***************************************************************************
//***************************************************************************
//***************************************************************************
void LoadDriver(void)
{
	 FILE *f;
	 long length;
	 char *sp;
	 char sn[129];

	 strcpy(sn,"");
	 sp = getenv("SOUND");
	 if(sp)
	 {
		  strcpy(sn,sp);
		  if(sn[strlen(sn)-1] != '\\')
				strcat(sn,"\\");
	 }
	 strcat(sn,"drv\\CT-VOICE.DRV");

	 f = fopen(sn,"rb");
	 if(!f)
	 {
		  Snd=FALSE;
		  return;
	 }
	 length = filelength(fileno(f));

	 driver_mem = (char far *)malloc((int)length + 16);
	 if(FP_SEG(driver_mem) != 0)
		  driver = MK_FP(FP_SEG(driver_mem)+1,0);
	 else
		  driver = (void *) driver_mem;

	 fread(driver,1,(int)length,f);

	 fclose(f);
}

int GetVersion(void)
{
	 _BX = 0;
	 (*driver)();
	 return _AX;
}

void SetIOAddr(int base)
{
	 _BX = 1;
	 _AX = base;
	 (*driver)();
}

void SetIRQ(int irq)
{
	 _BX = 2;
	 _AX = irq;
	 (*driver)();
}

int InitialiseDriver(void)
{
	 _BX = 3;
	 (*driver)();
	 return _AX;
}

void UninstallDriver(void)
{
	 _BX = 9;
	 (*driver)();
}

void SpeakerOnOff(int onoff)
{
	 _BX = 4;
	 _AX = onoff & 0x0001;
	 (*driver)();
}

void SetStatusWord(unsigned int *addr)
{
	 _BX = 5;
	 _ES = FP_SEG(addr);
	 _DI = FP_OFF(addr);
	 (*driver)();
}

void OutputVoice(char *buffer)
{
	 _BX = 6;
	 _ES = FP_SEG(buffer);
	 _DI = FP_OFF(buffer);
	 (*driver)();
}

void StopVoiceProcess(void)
{
	 _BX = 8;
	 (*driver)();
}

int PauseOutputVoice(void)
{
	 _BX = 10;
	 (*driver)();
	 return _AX;
}

int ContinueOutputVoice(void)
{
    _BX = 11;
    (*driver)();
    return _AX;
}

char *LoadVOC(char *name)
{
    FILE *f;
	 char *buf;
    long length;

	 f = fopen(name,"rb");
    if(!f)
        return NULL;

	 length = filelength(fileno(f)) - 0x1a;

    if (length > 65000L) length = 65000L;

	 buf = (char *)malloc((int)length);
    fseek(f,0x1a,SEEK_SET);
	 fread(buf,1,(unsigned int)length,f);

	 fclose(f);
	 return buf;
}

void DefineLevels(void)
{
	//LEVEL 1 (the first level)
	Level[0].IncomingFreq=20;
	Level[0].MissilesBase0=50;
	Level[0].MissilesBase1=50;
	Level[0].NumIncoming=25;
	Level[0].IncomingSpeed=2;
	Level[0].MissileSpeed=6;
	strcpy(Level[0].Background,"screen0.scr\0");
	strcpy(Level[0].Palette,"screen0.pal\0");
	Level[0].BldgIntact=4;
	Level[0].BldgDestroyed=5;
	Level[0].MissileSplitProb=0;
	Level[0].NumSplitWarheads=3;
	Level[0].BuzzBombProb=0;
	//LEVEL 2
	Level[1].IncomingFreq=17;
	Level[1].MissilesBase0=50;
	Level[1].MissilesBase1=50;
	Level[1].NumIncoming=30;
	Level[1].IncomingSpeed=2;
	Level[1].MissileSpeed=6;
	strcpy(Level[1].Background,"screen0.scr\0");
	strcpy(Level[1].Palette,"screen0.pal\0");
	Level[1].BldgIntact=4;
	Level[1].BldgDestroyed=5;
	Level[1].MissileSplitProb=0;
	Level[1].NumSplitWarheads=3;
	Level[1].BuzzBombProb=0;
	//LEVEL 3
	Level[2].IncomingFreq=15;
	Level[2].MissilesBase0=50;
	Level[2].MissilesBase1=50;
	Level[2].NumIncoming=35;
	Level[2].IncomingSpeed=2;
	Level[2].MissileSpeed=6;
	strcpy(Level[2].Background,"screen0.scr\0");
	strcpy(Level[2].Palette,"screen0.pal\0");
	Level[2].BldgIntact=4;
	Level[2].BldgDestroyed=5;
	Level[2].MissileSplitProb=0;
	Level[2].NumSplitWarheads=3;
	Level[2].BuzzBombProb=0;
	//LEVEL 4
	Level[3].IncomingFreq=15;
	Level[3].MissilesBase0=50;
	Level[3].MissilesBase1=50;
	Level[3].NumIncoming=30;
	Level[3].IncomingSpeed=2;
	Level[3].MissileSpeed=6;
	strcpy(Level[3].Background,"screen1.scr\0");
	strcpy(Level[3].Palette,"screen1.pal\0");
	Level[3].BldgIntact=6;
	Level[3].BldgDestroyed=7;
	Level[3].MissileSplitProb=10;
	Level[3].NumSplitWarheads=2;
	Level[3].BuzzBombProb=0;
	//LEVEL 5
	Level[4].IncomingFreq=15;
	Level[4].MissilesBase0=50;
	Level[4].MissilesBase1=50;
	Level[4].NumIncoming=30;
	Level[4].IncomingSpeed=2;
	Level[4].MissileSpeed=6;
	strcpy(Level[4].Background,"screen1.scr\0");
	strcpy(Level[4].Palette,"screen1.pal\0");
	Level[4].BldgIntact=6;
	Level[4].BldgDestroyed=7;
	Level[4].MissileSplitProb=10;
	Level[4].NumSplitWarheads=3;
	Level[4].BuzzBombProb=4;
	//LEVEL 6
	Level[5].IncomingFreq=12;
	Level[5].MissilesBase0=50;
	Level[5].MissilesBase1=50;
	Level[5].NumIncoming=30;
	Level[5].IncomingSpeed=2;
	Level[5].MissileSpeed=6;
	strcpy(Level[5].Background,"screen1.scr\0");
	strcpy(Level[5].Palette,"screen1.pal\0");
	Level[5].BldgIntact=6;
	Level[5].BldgDestroyed=7;
	Level[5].MissileSplitProb=10;
	Level[5].NumSplitWarheads=3;
	Level[5].BuzzBombProb=6;
	//LEVEL 7
	Level[6].IncomingFreq=13;
	Level[6].MissilesBase0=50;
	Level[6].MissilesBase1=50;
	Level[6].NumIncoming=25;
	Level[6].IncomingSpeed=2;
	Level[6].MissileSpeed=6;
	strcpy(Level[6].Background,"screen2.scr\0");
	strcpy(Level[6].Palette,"screen2.pal\0");
	Level[6].BldgIntact=8;
	Level[6].BldgDestroyed=9;
	Level[6].MissileSplitProb=0;
	Level[6].NumSplitWarheads=3;
	Level[6].BuzzBombProb=30;
	//LEVEL 8
	Level[7].IncomingFreq=10;
	Level[7].MissilesBase0=50;
	Level[7].MissilesBase1=50;
	Level[7].NumIncoming=60;
	Level[7].IncomingSpeed=2;
	Level[7].MissileSpeed=6;
	strcpy(Level[7].Background,"screen2.scr\0");
	strcpy(Level[7].Palette,"screen2.pal\0");
	Level[7].BldgIntact=8;
	Level[7].BldgDestroyed=9;
	Level[7].MissileSplitProb=0;
	Level[7].NumSplitWarheads=3;
	Level[7].BuzzBombProb=0;
	//LEVEL 9
	Level[8].IncomingFreq=15;
	Level[8].MissilesBase0=25;
	Level[8].MissilesBase1=25;
	Level[8].NumIncoming=30;
	Level[8].IncomingSpeed=2;
	Level[8].MissileSpeed=6;
	strcpy(Level[8].Background,"screen2.scr\0");
	strcpy(Level[8].Palette,"screen2.pal\0");
	Level[8].BldgIntact=8;
	Level[8].BldgDestroyed=9;
	Level[8].MissileSplitProb=0;
	Level[8].NumSplitWarheads=3;
	Level[8].BuzzBombProb=0;
	//LEVEL 10
	Level[9].IncomingFreq=20;
	Level[9].MissilesBase0=50;
	Level[9].MissilesBase1=50;
	Level[9].NumIncoming=35;
	Level[9].IncomingSpeed=2;
	Level[9].MissileSpeed=6;
	strcpy(Level[9].Background,"screen3.scr\0");
	strcpy(Level[9].Palette,"screen3.pal\0");
	Level[9].BldgIntact=10;
	Level[9].BldgDestroyed=11;
	Level[9].MissileSplitProb=40;
	Level[9].NumSplitWarheads=3;
	Level[9].BuzzBombProb=0;
	//LEVEL 11
	Level[10].IncomingFreq=11;
	Level[10].MissilesBase0=50;
	Level[10].MissilesBase1=50;
	Level[10].NumIncoming=35;
	Level[10].IncomingSpeed=2;
	Level[10].MissileSpeed=6;
	strcpy(Level[10].Background,"screen3.scr\0");
	strcpy(Level[10].Palette,"screen3.pal\0");
	Level[10].BldgIntact=10;
	Level[10].BldgDestroyed=11;
	Level[10].MissileSplitProb=10;
	Level[10].NumSplitWarheads=3;
	Level[10].BuzzBombProb=8;
	//LEVEL 12
	Level[11].IncomingFreq=11;
	Level[11].MissilesBase0=50;
	Level[11].MissilesBase1=50;
	Level[11].NumIncoming=35;
	Level[11].IncomingSpeed=2;
	Level[11].MissileSpeed=6;
	strcpy(Level[11].Background,"screen3.scr\0");
	strcpy(Level[11].Palette,"screen3.pal\0");
	Level[11].BldgIntact=10;
	Level[11].BldgDestroyed=11;
	Level[11].MissileSplitProb=5;
	Level[11].NumSplitWarheads=3;
	Level[11].BuzzBombProb=8;
	//LEVEL 13
	Level[12].IncomingFreq=11;
	Level[12].MissilesBase0=50;
	Level[12].MissilesBase1=50;
	Level[12].NumIncoming=35;
	Level[12].IncomingSpeed=2;
	Level[12].MissileSpeed=6;
	strcpy(Level[12].Background,"screen4.scr\0");
	strcpy(Level[12].Palette,"screen4.pal\0");
	Level[12].BldgIntact=12;
	Level[12].BldgDestroyed=13;
	Level[12].MissileSplitProb=5;
	Level[12].NumSplitWarheads=4;
	Level[12].BuzzBombProb=9;
	//LEVEL 14
	Level[13].IncomingFreq=11;
	Level[13].MissilesBase0=50;
	Level[13].MissilesBase1=50;
	Level[13].NumIncoming=20;
	Level[13].IncomingSpeed=2;
	Level[13].MissileSpeed=6;
	strcpy(Level[13].Background,"screen4.scr\0");
	strcpy(Level[13].Palette,"screen4.pal\0");
	Level[13].BldgIntact=12;
	Level[13].BldgDestroyed=13;
	Level[13].MissileSplitProb=8;
	Level[13].NumSplitWarheads=3;
	Level[13].BuzzBombProb=10;
	//LEVEL 15
	Level[14].IncomingFreq=11;
	Level[14].MissilesBase0=50;
	Level[14].MissilesBase1=50;
	Level[14].NumIncoming=40;
	Level[14].IncomingSpeed=2;
	Level[14].MissileSpeed=6;
	strcpy(Level[14].Background,"screen4.scr\0");
	strcpy(Level[14].Palette,"screen4.pal\0");
	Level[14].BldgIntact=12;
	Level[14].BldgDestroyed=13;
	Level[14].MissileSplitProb=8;
	Level[14].NumSplitWarheads=3;
	Level[14].BuzzBombProb=8;
	//LEVEL 16
	Level[15].IncomingFreq=11;
	Level[15].MissilesBase0=50;
	Level[15].MissilesBase1=50;
	Level[15].NumIncoming=35;
	Level[15].IncomingSpeed=2;
	Level[15].MissileSpeed=6;
	strcpy(Level[15].Background,"screen5.scr\0");
	strcpy(Level[15].Palette,"screen5.pal\0");
	Level[15].BldgIntact=14;
	Level[15].BldgDestroyed=15;
	Level[15].MissileSplitProb=5;
	Level[15].NumSplitWarheads=3;
	Level[15].BuzzBombProb=9;
	//LEVEL 17
	Level[16].IncomingFreq=10;
	Level[16].MissilesBase0=50;
	Level[16].MissilesBase1=50;
	Level[16].NumIncoming=20;
	Level[16].IncomingSpeed=2;
	Level[16].MissileSpeed=6;
	strcpy(Level[16].Background,"screen5.scr\0");
	strcpy(Level[16].Palette,"screen5.pal\0");
	Level[16].BldgIntact=14;
	Level[16].BldgDestroyed=15;
	Level[16].MissileSplitProb=8;
	Level[16].NumSplitWarheads=3;
	Level[16].BuzzBombProb=10;
	//LEVEL 18 (the last level)
	Level[17].IncomingFreq=11;
	Level[17].MissilesBase0=50;
	Level[17].MissilesBase1=50;
	Level[17].NumIncoming=40;
	Level[17].IncomingSpeed=2;
	Level[17].MissileSpeed=6;
	strcpy(Level[17].Background,"screen5.scr\0");
	strcpy(Level[17].Palette,"screen5.pal\0");
	Level[17].BldgIntact=14;
	Level[17].BldgDestroyed=15;
	Level[17].MissileSplitProb=8;
	Level[17].NumSplitWarheads=3;
	Level[17].BuzzBombProb=8;
}

