'*************************************************************************
'
' Concentration -- A Solitare Game
'
'  (c) Copyright 1989-95 by Randy Rasa
'                           18215 Troost
'                           Olathe, KS 66062
'
'  Notice: This source code is provided for reference and educational
'          purposes only, and is protected under United States Copyright
'          Law.  In other words, you may look this over, learn from it,
'          and play with it, but not steal it.
'
'   Command Line Syntax:  CONCEN [/Q][/M]
'           /Q = quiet mode -- most noises will be stifled
'           /M = mono mode -- black and white video
'
'*************************************************************************
'
'   Revision History
'
' Revision   Date   Description
' -------- -------- ---------------------------------------
'   0.00   11-14-89 program started
'   1.00   11-17-89 program completed
'   1.01   02-04-95 updated for freeware release.
'
'*************************************************************************
'
' Concentration was written with QuickBASIC 4.5, compiled to
' a stand-alone EXE file, and linked with NOCOM.OBJ and
' SMALLERR.OBJ (included with QB) to reduce the file size.
'
' This program makes use of routines provided in the
' QuickPak Professional library published by
'       Crescent Software, Inc.
'       11 Grandview Avenue
'       Stamford, CT 06905
'       (203) 846-2500
' The library is excellent and definitely recommended.
'
' Since this program calls routines in an external library,
' and I cannot distribute that library, I have included a
' "Quick Library" (CONCEN.QLB), which contains the external
' routines in a form usable within the QuickBASIC environment.
' Use the command line:
'       QB CONCEN /L CONCEN.QLB
' to load the program and quick library into QuickBASIC.
' You will be able to run the program, make changes, and
' fool around with the program all you want, but you will
' not be able to compile to an EXE file.  If you really want
' to do this you will either need to buy QuickPak Professional,
' or substitute your own routines.
'
'*************************************************************************

    DEFINT A-Z
    CONST FALSE = 0
    CONST TRUE = NOT FALSE
'
' QuickPak Professional routines
'
    DECLARE SUB Box0 (ULRow%, ULCol%, LRRow%, LRCol%, Char%, colr%)
    DECLARE SUB GetCursor (x%, y%, Button%)
    DECLARE SUB HideCursor ()
    DECLARE SUB InitMouse (There%)
    DECLARE SUB MouseTrap (ULRow%, ULCol%, LRRow%, LRCol%)
    DECLARE SUB SetCursor (x%, y%)
    DECLARE SUB ShowCursor ()
    DECLARE SUB TextCursor (fg%, bg%)
    DECLARE SUB QPrint0 (x$, colr%)
    DECLARE SUB ScrnSave0 (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%)
    DECLARE SUB ScrnRest0 (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%)
    DECLARE FUNCTION OneColor% (fg%, bg%)
    DECLARE SUB ClearScr0 (ULRow%, ULCol%, LRRow%, LRCol%, colr%)
    DECLARE FUNCTION Date2Num% (D$)
    DECLARE FUNCTION Time2Num% (T$)
    DECLARE FUNCTION Num2Date$ (D%)
'
' RAR's routines
'
    DECLARE SUB MorK (key$, x%, y%)
    DECLARE SUB DspCard (CardNumber%, Action%, CardValue%, CardColor%)
    DECLARE SUB PickCard (CardNum%, KeyPressed$)
  
    TYPE ScoreRecord
        Player AS STRING * 15
        Dat AS INTEGER
        Tim AS INTEGER
        Score AS INTEGER
    END TYPE

    DIM Scores(10) AS ScoreRecord

    REDIM scrn1(2000)                     'arrays to save screens
    REDIM Scrn2(2000)
    CALL ScrnSave0(1, 1, 25, 80, SEG scrn1(0))      'save calling screen
    OrigRow = CSRLIN

    RANDOMIZE TIMER
    cmnd$ = UCASE$(COMMAND$)
    IF INSTR(cmnd$, "/Q") <> 0 THEN Quiet = TRUE ELSE Quiet = FALSE   'check for quiet mode
    IF INSTR(cmnd$, "/M") <> 0 THEN
        video = &HB4
    ELSE
        DEF SEG = 0
        video = PEEK(&H463)                 'check for color card
    END IF

    IF video = &HB4 THEN
        foreground = 7          'mono
        background = 0
        Red = 0: Black = 0
        CardFG = 0: CardBG = 7
        norm = 7: inv = 112
        TitleFG = 0: TitleBG = 7: TitleColor = 112
    ELSE                        'color
        foreground = 15         ' bright white foreground
        background = 1          ' blue background
        Red = 4: Black = 0
        CardFG = 0: CardBG = 3
        norm = 31: inv = 113
        TitleFG = 0: TitleBG = 2: TitleColor = 32
    END IF
    norm = OneColor(foreground, background)                'Note: these lines are commented out
    inv = OneColor(background, foreground)                 ' to save a few bytes.
    TitleColor = OneColor(TitleFG, TitleBG)

    CALL InitMouse(mouse%)          'check for mouse (returns 0=no mouse, 1=mouse present)
    CALL TextCursor(-2, -2)         'set text cursor to be inverse
    FirstGame = TRUE
    CardDesign = 1
    CheckCardColor = FALSE
    '
    ' Start the game
    '
start:
    '
    ' Card Number Table:
    '
    '           |       Suit
    '     Value |H(3) D(4) C(5) S(6)
    '     ------|---- ---- ---- ----
    '         A |  1   14   27   40
    '         2 |  2   15   28   41
    '         3 |  3   16   29   42
    '         4 |  4   17   30   43
    '         5 |  5   18   31   44
    '         6 |  6   19   32   45
    '         7 |  7   20   33   46
    '         8 |  8   21   34   47
    '         9 |  9   22   35   48
    '        10 | 10   23   36   49
    '         J | 11   24   37   50
    '         Q | 12   25   38   51
    '         K | 13   26   39   52
    '
    REDIM card(53)
    FOR n = 1 TO 52
        card(n) = n             'initialize the deck
    NEXT
    '
    ' SHUFFLE the deck
    '
    FOR i = 1 TO (3 * 52)       ' go thru the deck 3 times
        x = INT(RND * 52) + 1
        y = INT(RND * 52) + 1
        SWAP card(x), card(y)
    NEXT i
    '
    ' deal the deck
    '
    COLOR foreground, background: CLS
    FOR n = 1 TO 52
        CALL DspCard(n, 0, CardValue, CardColor)
    NEXT
    '
    ' Set up game screen
    '
    row = 1: colr = inv: txt$ = " C O N C E N T R A T I O N ": GOSUB dspc
    COLOR foreground, background
    FOR n = 1 TO 13
        LOCATE 3, ((n - 1) * 5 + 10): PRINT CHR$(n + 64)
    NEXT
    FOR n = 1 TO 4
        LOCATE ((n - 1) * 4 + 5), 6: PRINT CHR$(n + 48)
    NEXT

    COLOR background, foreground
    LOCATE 20, 9: PRINT "     Help     ";
    LOCATE 20, 25: PRINT "   Cardface   ";
    GOSUB DspSound
    LOCATE 20, 57: PRINT "     Quit     ";
    '
    ' display titles
    '
    IF FirstGame THEN
        GOSUB DrawTitleBox
        colr = TitleColor
        row = 7: txt$ = "C O N C E N T R A T I O N": GOSUB dspc
        row = row + 1
        txt$ = "Version 1.01": GOSUB dspc1
        row = row + 1
        txt$ = "By Randy Rasa": GOSUB dspc1
        txt$ = "18215 Troost": GOSUB dspc1
        txt$ = "Olathe, KS 66062": GOSUB dspc1
        row = row + 1
        txt$ = "(C) Copyright 1989-95 by Randy Rasa": GOSUB dspc1
        GOSUB EraseTitleBox
        HiScore = 0: LoScore = 0: AvgScore = 0
        TotalScores = 0: NumGames = 0: GamesWon = 0
        FirstGame = FALSE
    END IF
    Matches = 0: Attempts = 0
    GOSUB DspScore
    CALL SetCursor(10 * 8 - 8, 5 * 8 - 8)
    '
    ' Play
    '
    DO
        colr = norm
        txt$ = "Select your first card ...": GOSUB dspc25
        CALL MouseTrap(4, 8, 20, 71)
        CALL PickCard(FirstCard, Ky$)
        IF Ky$ = "" THEN
            CALL DspCard(FirstCard, 1, FirstCardValue, FirstCardColor)
            CALL MouseTrap(4, 8, 18, 71)
            txt$ = "Select your second card ...": GOSUB dspc25
            DO
                CALL PickCard(SecondCard, Ky$)
                IF SecondCard = FirstCard THEN SecondCard = 0
                IF Ky$ <> "" THEN SecondCard = 0: Ky$ = ""
            LOOP UNTIL SecondCard <> 0
            CALL DspCard(SecondCard, 1, SecondCardValue, SecondCardColor)
            IF NOT CheckColor THEN FirstCardColor = SecondCardColor
            IF FirstCardValue <> SecondCardValue AND FirstCardColor = SecondCardColor THEN
                IF NOT Quiet THEN SOUND 100, 2
                txt$ = "Not a match.  Please try again.": GOSUB dspc25
                SLEEP 1
                CALL DspCard(FirstCard, 0, FirstCardValue, FirstCardColor)
                CALL Pause(5)
                CALL DspCard(SecondCard, 0, SecondCardValue, SecondCardColor)
            ELSE
                txt$ = "That's a match!": GOSUB dspc25
                CALL DspCard(FirstCard, 2, FirstCardValue, FirstCardColor)
                IF Quiet THEN CALL Pause(5)
                CALL DspCard(SecondCard, 2, SecondCardValue, SecondCardColor)
                card(FirstCard) = 0
                card(SecondCard) = 0
                Matches = Matches + 1
            END IF
            Attempts = Attempts + 1
            GOSUB DspScore
        ELSE
            SELECT CASE Ky$
                CASE "H"
                    GOSUB DrawTitleBox
                    colr = TitleColor
                    row = 5: txt$ = " Help ": GOSUB dspc
                    row = 6
                    txt$ = "The object of the game is to turn up pairs of": GOSUB dspc1
                    txt$ = "cards, attempting to make matches.  If a match": GOSUB dspc1
                    txt$ = "is made, the cards are removed, otherwise they": GOSUB dspc1
                    txt$ = "are turned back over.  The game continues": GOSUB dspc1
                    txt$ = "until all cards are removed.": GOSUB dspc1
                    row = row + 1
                    txt$ = "The left mouse button is used to select a card,": GOSUB dspc1
                    txt$ = "the right button (or 'Esc') shells to DOS, and": GOSUB dspc1
                    txt$ = "the middle button (or 'B') blanks the screen.": GOSUB dspc1
                    GOSUB EraseTitleBox
                CASE "C"
                    CardDesign = CardDesign + 1: IF CardDesign > 7 THEN CardDesign = 0
                    FOR n = 1 TO 52
                        IF card(n) <> 0 THEN CALL DspCard(n, 0, CardValue, CardColor)
                    NEXT
                CASE "S"
                    IF Quiet THEN Quiet = FALSE ELSE Quiet = TRUE
                    GOSUB DspSound
                CASE "Q"
                    txt$ = "Are you sure you want to quit (Y/N)?": GOSUB dspc25
                    CALL MouseTrap(25, 53, 25, 55)
                    CALL SetCursor(53, 25)
                    CALL MorK(ans$, x, y)
                    IF x = 53 OR ans$ = "Y" THEN GOTO TheEnd
                CASE CHR$(27), "B"  'Esc or B
                    CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
                    COLOR 7, 0
                    CLS
                    IF Ky$ = "B" THEN
                        DO
                            CALL GetCursor(x, y, Button)      'wait until all mouse buttons are released
                        LOOP UNTIL Button = 0
                        DO
                            Ky$ = UCASE$(INKEY$)
                            CALL GetCursor(x, y, Button)      'wait for mouse button to be pressed
                        LOOP UNTIL Button <> 0 OR Ky$ <> ""
                    ELSE
                        PRINT "Type 'Exit' to return ..."
                        SHELL
                    END IF
                    CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
            END SELECT
            Ky$ = ""
        END IF
    LOOP UNTIL Matches = 26

    OPEN "CONCEN.DAT" FOR RANDOM AS #1 LEN = 21
    NumberOfScores = LOF(1) \ 21    'read scores from data file
    FOR n = 1 TO NumberOfScores
        GET #1, n, Scores(n)
    NEXT
    IF Scores(1).Score = 0 THEN     'if first time, then initialize scores
        FOR n = 1 TO 10
            Scores(n).Score = 1000
        NEXT
    END IF

    IF Scores(10).Score >= Attempts THEN
        GOSUB ClrLin25
        LOCATE 25, 25: PRINT "Enter your name: ";
        PlayersName$ = PlayersName$ + SPACE$(15 - LEN(PlayersName$))
        DO
            CALL Editor(PlayersName$, 15, ScanCode, 0, 0, inv, inv, 25, POS(0))
        LOOP UNTIL PlayersName$ <> ""
        Scores(10).Player = PlayersName$
        Scores(10).Dat = Date2Num(DATE$)
        Scores(10).Tim = Time2Num(TIME$)
        LastTim = Scores(10).Tim
        Scores(10).Score = Attempts
    END IF
 
    CALL SortT(SEG Scores(1), 10, 0, 21, 19, -1)    'sort scores into ascending order
    FOR n = 1 TO 10
        PUT #1, n, Scores(n)        'write scores to disk
    NEXT
    CLOSE #1

    ULRow = 5: ULCol = 9
    CALL Box0(ULRow, ULCol, ULRow + 11, ULCol + 38, 1, inv)
    CALL ClearScr0(ULRow + 1, ULCol + 1, ULRow + 10, ULCol + 37, inv)
    COLOR background, foreground
    LOCATE ULRow, ULCol + 2: PRINT " Top Scores "
    FOR n = 1 TO 10
        IF Scores(n).Score = Attempts AND Scores(n).Tim = LastTim THEN COLOR background + 16, foreground ELSE COLOR background, foreground
        LOCATE ULRow + n, ULCol + 2: PRINT USING "##."; n
        IF Scores(n).Score <> 1000 THEN
            LOCATE ULRow + n, ULCol + 6: PRINT Scores(n).Player
            LOCATE ULRow + n, ULCol + 22: PRINT Num2Date$(Scores(n).Dat)
            LOCATE ULRow + n, ULCol + 33: PRINT USING "###"; Scores(n).Score
        ELSE
            LOCATE ULRow + n, ULCol + 6: PRINT "............... .......... ..."
        END IF
    NEXT

    TotalScores = TotalScores + Attempts
    IF Attempts > HiScore THEN HiScore = Attempts
    IF Attempts < LoScore OR LoScore = 0 THEN LoScore = Attempts
    AvgScore = TotalScores \ (NumGames + 1)
    NumGames = NumGames + 1
    ULRow = 5: ULCol = 49
    CALL Box0(ULRow, ULCol, ULRow + 11, ULCol + 21, 1, inv)
    CALL ClearScr0(ULRow + 1, ULCol + 1, ULRow + 10, ULCol + 20, inv)
    COLOR background, foreground
    LOCATE ULRow, ULCol + 2: PRINT " Your Statistics "
    LOCATE ULRow + 2, ULCol + 2: PRINT "Games Played:"; NumGames
    LOCATE ULRow + 3, ULCol + 2: PRINT "Best Score:"; LoScore
    LOCATE ULRow + 4, ULCol + 2: PRINT "Worst Score:"; HiScore
    LOCATE ULRow + 5, ULCol + 2: PRINT "Average Score:"; AvgScore

    colr = norm
    txt$ = "Play Again (Y/N)?": GOSUB dspc25
    CALL MouseTrap(25, 44, 25, 46)
    CALL SetCursor(44, 25)
    CALL MorK(ans$, x, y)
    IF x = 44 OR ans$ = "Y" THEN GOTO start
TheEnd:
    COLOR 7, 0
    LOCATE OrigRow, 1
    CALL ScrnRest0(1, 1, 25, 80, SEG scrn1(0))      'restore calling screen
    END
'
'************** End Of Main Program ******************
'-------------- Start Of Subroutines -----------------
'
'   Display a string
'
dsp1:
    row = row + 1   'automatically increment row
dsp:
    LOCATE row, col, 0
    CALL QPrint0(txt$, colr)
    RETURN
'
'   display a string (centered)
'
dspc25:
    GOSUB ClrLin25
    row = 24
dspc1:
    row = row + 1
dspc:
    col = 40 - LEN(txt$) \ 2
    GOTO dsp
'
' clear line 25 (status line)
'
ClrLin25:
    LOCATE 25, 1
    CALL QPrint0(SPACE$(80), norm)
    RETURN
'
' Display "Press any key ..." and wait for key or mouse
'
PressAnyKey:
    colr = norm
    txt$ = "Press any key ...": GOSUB dspc25
    CALL MouseTrap(25, 32, 25, 48)
    CALL SetCursor(25, 48)
    CALL MorK(ans$, x, y)
    RETURN
'
' Display Scores
'
DspScore:
    COLOR foreground, background
    LOCATE 22, 57: PRINT "Matches:"; Matches;
    LOCATE 23, 57: PRINT "Attempts:"; Attempts;
    RETURN
'
' display current sound status
'
DspSound:
    COLOR background, foreground
    IF Quiet THEN txt$ = "  Sound: Off  " ELSE txt$ = "  Sound: On   "
    LOCATE 20, 41: PRINT txt$;
    RETURN
'
' draw title box
'
DrawTitleBox:
    CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
    CALL Box0(5, 15, 17, 65, 2, TitleColor)
    CALL ClearScr0(6, 16, 16, 64, TitleColor)
    RETURN
EraseTitleBox:
    GOSUB PressAnyKey
    CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
    RETURN

SUB DspCard (CardNumber%, Action%, CardValue%, CardColr%)
'
' Action: 0 = display back of card
'         1 = display front of card
'         2 = display blank
'

SHARED CardFG, CardBG, card(), foreground, background, CardDesign, Quiet, Red, Black

    IF CardNumber = 0 THEN EXIT SUB
    ULRow = ((CardNumber - 1) \ 13) * 4 + 4
    ULCol = ((CardNumber - 1) MOD 13) * 5 + 8
    value = (card(CardNumber) - 1) MOD 13 + 1: CardValue = value
    Suit = (card(CardNumber) - 1) \ 13 + 3
    IF Suit < 5 THEN CardColr = 0 ELSE CardColr = 1
    SELECT CASE value
        CASE 1: Crd$ = " A"
        CASE 2 TO 9: Crd$ = STR$(value)
        CASE 10: Crd$ = "10"
        CASE 11: Crd$ = " J"
        CASE 12: Crd$ = " Q"
        CASE 13: Crd$ = " K"
    END SELECT
    IF Suit < 5 THEN
        card.color = Red      'red for hearts or diamonds
    ELSE
        card.color = Black    'black for clubs or spades
    END IF
    IF LEFT$(Crd$, 1) = " " THEN
        CrdH$ = RIGHT$(Crd$, 1): CrdL$ = " "
    ELSE
        CrdH$ = LEFT$(Crd$, 1): CrdL$ = RIGHT$(Crd$, 1)
    END IF
    SELECT CASE Action
        CASE 0
            COLOR CardFG, CardBG
            SELECT CASE CardDesign
                CASE 0
                    txt1$ = ""
                    txt2$ = ""
                    txt3$ = ""
                CASE 1
                    txt1$ = ""
                    txt2$ = ""
                    txt3$ = ""
                CASE 2
                    txt1$ = ""
                    txt2$ = ""
                    txt3$ = ""
                CASE 3
                    txt1$ = ""
                    txt2$ = ""
                    txt3$ = ""
                CASE 4
                    txt1$ = "    "
                    txt2$ = " " + CHR$(1) + CHR$(2) + " "
                    txt3$ = "    "
                CASE 5
                    txt1$ = ""
                    txt2$ = ""
                    txt3$ = ""
                CASE 6
                    txt1$ = ""
                    txt2$ = txt1$
                    txt3$ = txt1$
                CASE 7
                    txt1$ = "<<<<"
                    txt2$ = ">>>>"
                    txt3$ = "<<<<"
            END SELECT
            LOCATE ULRow + 0, ULCol: PRINT txt1$
            LOCATE ULRow + 1, ULCol: PRINT txt2$
            LOCATE ULRow + 2, ULCol: PRINT txt3$
        CASE 1
            COLOR CardColor, CardBG
            LOCATE ULRow + 0, ULCol: PRINT CrdH$; CrdL$; " "; CHR$(Suit)
            LOCATE ULRow + 1, ULCol: PRINT "    "
            LOCATE ULRow + 2, ULCol: PRINT CHR$(Suit); " ";
            IF CrdL$ = " " THEN
                PRINT CrdL$; CrdH$;
            ELSE
                PRINT CrdH$; CrdL$;
            END IF
        CASE 2
            COLOR foreground, background
            LOCATE ULRow + 0, ULCol: PRINT "  "
            LOCATE ULRow + 1, ULCol: PRINT "    "
            LOCATE ULRow + 2, ULCol: PRINT "  "
    END SELECT
    IF NOT Quiet THEN
        SELECT CASE Action
            CASE 0
                'FOR s = 1000 TO 100 STEP -200: SOUND s, .1: NEXT
            CASE 1
                FOR S = 100 TO 1000 STEP 200: SOUND S, .1: NEXT
            CASE 2
                FOR S = 100 TO 1000 STEP 100: SOUND S, .1: CALL Pause(1): NEXT
        END SELECT
    ELSE
        'CALL Pause(2)
    END IF

END SUB

SUB MorK (Ky$, x, y)
'
'   get mouse or keyboard input
'
'   Inputs: none
'   Outputs: key$ -- key pressed ("" if no key pressed)
'            x,y -- mouse position when button was pressed
'                   x = text col, y = text row
'                   0,0 if mouse button not pressed
'
    CALL ShowCursor
    DO
        CALL GetCursor(x, y, Button)      'wait until all mouse buttons are released
    LOOP UNTIL Button = 0
    DO
        Ky$ = UCASE$(INKEY$)
        CALL GetCursor(x, y, Button)      'wait for mouse button to be pressed
    LOOP UNTIL Button <> 0 OR Ky$ <> ""
    SELECT CASE Button
        CASE 1
            x = x \ 8 + 1
            y = y \ 8 + 1
        CASE 2
            Ky$ = CHR$(27)
            x = 0: y = x
        CASE 4
            Ky$ = "B"
            x = 0: y = x
        CASE ELSE
            x = 0: y = x
    END SELECT
    CALL HideCursor

END SUB

SUB PickCard (CardNum%, KeyPressed$)
'
' CardNum = 0 if key pressed
' KeyPressed$ = "" if card picked
'

SHARED Quiet, card(), mouse, foreground, background

PickCard:
    IF NOT mouse THEN
        COLOR foreground, background
        LOCATE 24, 32: PRINT "Row:     Col: ";
        LOCATE 24, 37, 1: CALL MorK(ans$, mx, my)
        IF ans$ > "0" AND ans$ < "5" THEN
            y = VAL(ans$)
            PRINT ans$;
            DO
                LOCATE 24, 47, 1: CALL MorK(ans$, mx, my)
            LOOP UNTIL ans$ >= "A" AND ans$ <= "M"
            PRINT ans$;
            x = ASC(ans$) - 64
            xy = x + (y - 1) * 13
            ans$ = ""
        END IF
        LOCATE 24, 30: PRINT SPACE$(20);
    ELSE
        xy = 0: ans$ = ""
        CALL MorK(Place$, mx, my)
        IF mx < 72 THEN
            SELECT CASE my
                CASE 4 TO 6: y = 1
                CASE 8 TO 10: y = 2
                CASE 12 TO 14: y = 3
                CASE 16 TO 18: y = 4
                CASE ELSE: y = 0
            END SELECT
            SELECT CASE mx
                CASE 8 TO 11: x = 1
                CASE 13 TO 16: x = 2
                CASE 18 TO 21: x = 3
                CASE 23 TO 26: x = 4
                CASE 28 TO 31: x = 5
                CASE 33 TO 36: x = 6
                CASE 38 TO 41: x = 7
                CASE 43 TO 46: x = 8
                CASE 48 TO 51: x = 9
                CASE 53 TO 56: x = 10
                CASE 58 TO 61: x = 11
                CASE 63 TO 66: x = 12
                CASE 68 TO 71: x = 13
                CASE ELSE: x = 0: y = 0
            END SELECT
            IF y = 0 THEN xy = 0 ELSE xy = x + (y - 1) * 13
        END IF
        IF my = 20 THEN
            SELECT CASE mx
                CASE 9 TO 22: ans$ = "H"
                CASE 25 TO 38: ans$ = "C"
                CASE 41 TO 54: ans$ = "S"
                CASE 57 TO 70: ans$ = "Q"
                CASE ELSE: ans$ = "Z"
            END SELECT
        END IF
        IF mx = 0 THEN ans$ = Place$
    END IF
    IF ans$ <> "" THEN
        KeyPressed$ = ans$
    ELSE
        IF xy <> 0 AND card(xy) <> 0 THEN
            CardNum = xy
        ELSE
            IF NOT Quiet THEN SOUND 250, .5
            GOTO PickCard
        END IF
    END IF

END SUB

