





						 (**************************************
                   *  *
                   *       Football Manager 2000       *
                   *              						     *
                   *                By				     *
                   *              						     *
                   *            Fraser King			     *
                   *  *
                   **************************************)






program Football_Manager_2000;

{
  the current folder needs to be in fm2000 folder or the parent of
  fm2000 folder, for the program to compile (use 'Change Dir' in File menu)
}

uses
	crt;

const
	MAX_TEAMS           = 10;   MAX_PLAYERS       	= 21;
   NO_OF_MATCHES       = 36;   MAX_CHECK         	= 250;
   NO_OF_TRANSFER_LIST = 53;   NO_OF_CHECKS        = 23;
   GAME_WAIT           = 9;    MATCH_COMMENTARY_NO = 7;
   MENU_NUMBER         = 9;    SPEED_NUMBER        = 15;
	MAX_PATH            = 79;	 MAX_STRING			   = 20;
   MAX_MANAGER         = 20;   MAX_PLAYER_NAME     = 11;
   MAX_TEAM_NAME       = 15;   MAX_DIGITS          = 8;
   NO_OF_FIXTURE_LIST  = 90;   NO_OF_MAIN_TEAM     = 11;
	MAX_GAME_SAVED      = 10;   SPONSOR_MAX         = 16;

   UP_ARROW            = #72;  DOWN_ARROW          = #80;
   LEFT_ARROW          = #75;  RIGHT_ARROW         = #77;
   RETURN              = #13;  SPACEBAR         	= #32;
   ESCAPE              = #27;  TAB           	   = #9;
   CTRL_LEFT 			  = #115; CTRL_RIGHT				= #116;
   LeFT_POiNTeR        = #175; RiGHT_POiNTeR       = #174;
   COMMA          	  = #44;  BACKSPACE           = #8;
   UNDERLINE           = #22;	 FULL_STOP 			   = #46;
   ALT_S               = #31;  ALT_C               = #46;
   ALT_H               = #35;  ALT_F               = #33;
   ALT_T               = #20;  ALT_V               = #47;
   ALT_I					  = #23;  NULL                = #0;

	MIN_AGE             = 18;   MAX_AGE					= 40;
	EMPTY		           = '';   SPC		            = ' ';
	AMOUNT_OF_TIPS      = 13;	 INJURY_TIME         = 4;
	FULL_TIME	    	  = 90;	 HALF_TIME	         = 45;
	TRANS_NO     		  = 10; 	 MAX_SKILL			   = 9;
	REFEREE_MAX			  = 13;	 NO_OF_LINES 		   = 22;
   FILES					  = 4;

   c1 			 : integer = BROWN;
	c2 			 : integer = RED;

   playerTotal  : integer = 19;
   exit_intro   : boolean = false;
   path         : string  = '';

  	match : array[1..MATCH_COMMENTARY_NO] of string[20] =
  ('scored a goal',
	'just missed the post',
	'hit the bar',
	'have a freekick',
   'got a man sent off',
	'have a penalty',
	'got a man injured');

   days_per_month : array[1..12] of integer =
  (31,28,31,30,31,30,31,31,30,31,30,31);

   player_position : array[1..4] of string[8] =
  ('Keeper',
	'Defender',
	'Midfield',
	'Forward'); { add a 5th one (subs) }

   morale_type : array[1..3] of string[7] =
  ('Low',
	'Average',
	'High');

   	{  	 Special Effects        }
		{   -----------------------   }
		{  1 		   - intro 			   }
		{  2 		   - colourtext 	   }
		{  3,4,5 	- play match      }
		{  6,7,8 	- speed options   }
		{  9 		   - single display  }
		{  10,11	   - end intro       }
		{  12		   - display cup     }
		{  13,14,15 - display stars   }

	speed : array[1..SPEED_NUMBER] of word = {remove the last 3 numbers}
  (150,100,3000,1500,2000,250,125,65,50,1500,5,100,100,50,30);

	Fname : array[1..4] of string[12] =
  ('saved.dat','details.dat','help.txt','tips.txt');

type
	table_record =
   RECORD
   	played,won,draw,lost,f,a,pts : integer;
   END;

   teams_record =
   RECORD
   	name    : string[MAX_TEAM_NAME];
      table   : table_record;
      scores  : integer;
      manager : string[MAX_MANAGER];
      players : array[1..MAX_PLAYERS] of string[MAX_PLAYER_NAME];
   END;

   stats_record =
   RECORD
   	on_target,off_target,penalty,injured,sent_off : integer;
   END;

   transfer_record =
   RECORD
   	Tname         : string[MAX_PLAYER_NAME];
      Tprice        : longint;
      Tpresent_team : string[MAX_TEAM_NAME];
      Tposition     : string[8];
   	Tskill        : integer;
   END;

   date_format =
   RECORD
   	day,month,year,wks : integer;
   END;

   options_record =
   RECORD
   	match,speed,change : integer;
   END;

   table_numbers_record =
   RECORD
   	pts,pos : integer;
   	switch  : boolean;
   END;

   team_stats_record =
   RECORD
      position,morale  : string[8];
   	price,wages      : longint;
      skill,scored,age : integer;
		years,games_off  : integer;
		ch               : char;
      endwk            : integer;
   	captain          : boolean;
   END;

   saveSettingsRecord =
   RECORD
   	formatDate : array[1..2] of integer;
      weekCount,quarterFixture : integer;
   END;

   sponsorRecord =
   RECORD
   	name  : string[10];
      price : longint;
   END;

   savedSponsorRecord =
   RECORD
      savedname  : string[10];
   	savedprice : longint;
      endwk      : integer;
   	check      : boolean;
   	counter    : integer;
   END;

   transactionsRecord =
   RECORD
   	cDate    : date_format;
		Activity : string[10];
      PaidOut,PaidIn,cBalance : longint;
   END;

   bankDetailsRecord =
   RECORD
   	loan,balance,max_loan : longint;
      transactions : array[1..TRANS_NO] of transactionsRecord;
   END;

   contractRecord =
   RECORD
   	no_of_years : integer;
      wage			: longint;
      extra			: integer;
   END;

   data_record =
   RECORD
		tLeague,tPlayer : integer;
		tName			    : integer;
		tSkill   		 : integer;
		tPrice,tWages   : longint;
   	tPosition       : string[8];
   END;

   save_page_record =
   RECORD
		sRow,sPage : integer;
   END;

	teams_type				= array[1..4,1..MAX_TEAMS] of teams_record;
	stats_type				= array[1..2] of stats_record;
{	date_type				= date_format;}
	transfer_list_type	= array[1..NO_OF_TRANSFER_LIST] of transfer_record;

	check_type				= array[1..NO_OF_CHECKS] of boolean;
{	options_type			= options_record;}
	hi_type					= array[1..4] of integer;
	low_type					= array[1..3] of integer;

	fixtureListType		= array[1..NO_OF_FIXTURE_LIST] of integer;
	table_numbers_type	= array[1..MAX_TEAMS] of table_numbers_record;
	team_stats_type		= array[1..MAX_PLAYERS] of team_stats_record;
	suspensionStore_type	= array[1..2] of integer;

	saveSettingsType		= saveSettingsRecord;
	positionCheckType		= array[2..4] of boolean;
	posType					= array[1..2,1..NO_OF_MAIN_TEAM] of integer;
	formationType			= array[1..4] of integer;

	tmpType					= array[1..4] of integer;
	sponsorType				= array[1..SPONSOR_MAX] of sponsorRecord;
	savedSponsorType		= savedSponsorRecord;
   bankDetailsType		= bankDetailsRecord;

   contractType			= contractRecord;
   data_type				= data_record;
   save_page_type			= save_page_record;
   referee_type			= array[1..REFEREE_MAX] of string[10];

	titlesize				= string[14];


var
	teams           : teams_type;
	transfer_list   : transfer_list_type;
   fixtureList     : fixtureListType;
   stats           : stats_type;
   options         : {options_type}options_record;
   table_numbers	 : table_numbers_type;
   suspensionStore : suspensionStore_type;
   saveSettings    : saveSettingsType;
   team_stats 		 : team_stats_type;
   positionCheck   : positionCheckType;
   savedSponsor    : savedSponsorType;
   sponsor         : sponsorType;
   pos             : posType;
   check           : check_type;
   date            : {date_type}date_format;
   hi              : hi_type;
   low             : low_type;
   tmp				 : tmpType;
   def,mid,forw 	 : formationType;
   bankDetails		 : bankDetailsType;
   contract			 : contractType;
   data				 : data_type;
   save_page		 : save_page_type;
   referee			 : referee_type;


function centre_line(text : string) : integer;

begin
	centre_line := (80 - length(text) + 1) div 2;
end;


procedure pause(var ch : char);

begin
{   textcolor(black);}
	ch := readkey;

   if keypressed then
   	ch := readkey;

	if ch = #3 then { Ctrl-C }
   begin
   	textcolor(lightgray);
      clrscr;
{      nosound;}
		halt;
   end;
end;


procedure clrwin(x1,y1,x2,y2 : integer);

begin
	window(x1,y1,x2,y2);
   clrscr;
   window(1,1,80,25);
end;


procedure cls; { clears everything apart from the date }

begin
	clrwin(1,1,70,25);
   clrwin(70,3,80,25);
   clrwin(70,2,73,2);
end;


function random_limits(min,max : integer) : integer;

begin
	random_limits := random(max-min+1)+min;
end;


function conv(number : longint) : string;

var
	tmpstr : string;

begin
	str(number,tmpstr);
   conv := tmpstr;
end;


procedure avoid_escape(var ch : char);

begin
	if ch = ESCAPE then
   	ch := NULL;
end;


procedure limits(var number : integer;
					     min,max : integer);

begin
	if number <= min then
		number := min
   else
   if number >= max then
		number := max;
end;


procedure writeto(text : string;
						 x,y : integer;
				    colour : integer);

begin
	textcolor(colour);
   gotoxy(x,y);
   write(text);
end;


procedure calc_league_title(league : integer;
								 var title : titlesize);

begin
	if league = 1 then
   	title := 'Premier League'
   else
   	title := 'Division '+conv(league-1);
end;


procedure colourchar(text : string;
					       row : integer);

var
	i : integer;

begin
   gotoxy(centre_line(text),row);

	for i := 1 to length(text) do
   begin
      textcolor(random_limits(9,15));
      write(text[i]);
   end;
end;


procedure writecolour(text : string;
							  row : integer);

var
	len,i : integer;
   count : integer;

begin
   count := 0;
	for i := 1 to length(text) do
   	if text[i] = '#' then
      	inc(count,2);

   len := length(text)-count;
   gotoxy(40-(len div 2),row);

   for i := 1 to len do
   begin
   	if text[i] = '#' then
      begin
      	if text[i+1] = '1' then
         	textcolor(c1)
         else
            textcolor(c2);
         delete(text,i,2);
      end;
      write(text[i]);
	end;
end;


procedure scroll_colour(text : string);

var
	count,i : integer;
	column  : integer;
	m       : integer;
	ch      : char;

begin
   if exit_intro then
		exit;
   clrscr;
   column := centre_line(text);
   count := column;
   for i := 1 to length(text) do
   begin
   	gotoxy(column,12);
   	textcolor(c1);
		write(text);
      gotoxy(count,12);
      textcolor(c2);
      write(text[i]);
      gotoxy(1,25);
      textcolor(black);
      for m := 1 to speed[1] div 10 do
      begin
			delay(10);
         if keypressed then
         begin
         	pause(ch);
            if ch = ESCAPE then
            begin
            	exit_intro := true;
         		exit;
            end;
         end;
      end;
      inc(count);
   end;
	clrscr;
end;


procedure colourletter(x1,x2,y1,y2 : integer;
                   		 col1,col2 : integer;
					     			 letter : char);
begin
   if (col2 >= 9) and (col2 <= 15) then
   	dec(col2,8);

   if (col1 = 7) and (col2 = 7) then
   	col1 := 8;

   if col2 = 8 then
   begin
   	col2 := 7;
   	if col1 = 7 then
   		col1 := 8;
   end;

	window(x1,x2,y1,y2);
   textbackground(col2);
   clrscr;
   window(1,1,80,25);

   writeto(letter,x1,x2,col1);
   textbackground(black);
end;


procedure set_file(var txtfile : text;
							  details : string;
							     name : string);

begin
   if details <> 'close' then
   begin
		assign(txtfile, name);
      if details = 'reset' then
   		reset(txtfile)
      else
      if details = 'rewrite' then
      	rewrite(txtfile);
   end else
   	close(txtfile);
end;


procedure writexy(text : string;
				       row : integer;
			       colour : integer);

begin
   writeto(text,centre_line(text),row,colour);
	textcolor(black);
	gotoxy(1,25);
end;


procedure readxy(row : integer;
					  max : integer;
				var text : string);

var
	count : integer;
   ch    : char;

begin
   count := 1;
   text := EMPTY;
	repeat
      pause(ch);
      case ch of
         ESCAPE :
         begin
         	clrwin(1,row,80,row);
            count := 1;
            text := EMPTY;
         end;
			BACKSPACE :
         if count > 1 then
  			begin
	  			dec(count);
   			write(BACKSPACE,SPC,BACKSPACE);
    			delete(text,count,1);
            clrwin(1,row,80,row);
            writexy(text,row,c2);
   		end;
			SPACEBAR..#127,#156 :
         if count <= max then
      	begin
      		inc(count);
   			text := text + ch;
            writexy(text,row,c2);
      	end;
      end;
   until ch = RETURN;
end;


procedure colourtext(text : string;
							 row : integer);

begin
   repeat
      writexy(text,row,random_limits(1,15));
      delay(speed[2]);
   until keypressed;
end;


procedure end_intro(text : string);

var
	len,pos : integer;
	column  : integer;
	i,m,y   : integer;

begin
	column := centre_line(text);
   len := length(text);
   pos := len;
	for i := 1 to len do
   begin
      cls;
      gotoxy(column,12);
      textcolor(c1);
   	write(text);
      if i = 1 then
      begin
         textcolor(black);
         gotoxy(1,25);
      	delay(speed[10]);
      end;
      delete(text,pos,1);
      dec(pos);
      y := pos+column;
      for m := pos+column to 80 do
      begin
      	gotoxy(y,12);
         textcolor(c2);
      	write('-');
         gotoxy(1,25);
         delay(speed[11]);
         gotoxy(y,12);
         write(SPC);
         inc(y);
      end;
      textcolor(black);
   end;
end;


procedure display_spacebar_message(row : integer);

var
	ch : char;

begin
	writecolour('#1'+'Press '+'#2'+'SPACEBAR'+'#1'+' to continue',row);
   while ch <> SPACEBAR do
   	pause(ch);
end;


function commas(num : longint) : string;

var
	count  : integer;
	len,i  : integer;
	number : string;

begin
   count := 2;
	str(num,number);
   len := length(number);
   for i := len downto 1 do
   begin
   	if len-count = i then
   	begin
   		insert(COMMA,number,i);
     		inc(count,3);
      	if number[1] = COMMA then
				delete(number,1,1);
   	end;
   end;
   commas := number;
end;


procedure intro;

begin
   scroll_colour('Fraser King');
   scroll_colour('Presents');
   scroll_colour('Football Manager 2000');
end;


procedure display_fixture(homeTeam,awayTeam : integer;
												 league : integer;
						 			   		 player : integer;
									 lgepos1,lgepos2 : byte);
var
	tmpstr : titlesize;
	i      : integer;
	ch     : char;

begin
   cls;

	calc_league_title(league,tmpstr);
   writexy('League Match - '+tmpstr,11,c2);

   writecolour('#1'+teams[league,homeTeam].name+'#2'+' ('+'#1'+conv(lgepos1)+
	'#2'+')'+'#1'+' v '+teams[league,awayTeam].name+'#2'+' ('+'#1'+
	conv(lgepos2)+'#2'+')',13);

   gotoxy(1,25);
   pause(ch);
   cls;
end;


procedure display_final_score(homeTeam,awayTeam : integer;
													  league : integer);
var
	ch : char;

begin
	cls;
   writexy('Full Time',11,c2);

 	writecolour('#1'+teams[league,homeTeam].name+'#2'+SPC+
	conv(teams[league,homeTeam].scores)+SPC+
	conv(teams[league,awayTeam].scores)+'#1'+SPC+
	teams[league,awayTeam].name,13);

   pause(ch);
   cls;
end;


procedure add_scorers;

var
	rnd : integer;

begin
	repeat
      case random_limits(1,20) of
      	1..2  : rnd := random_limits(2,5);
         3..5  : rnd := random_limits(6,9);
         5..20 : rnd := random_limits(10,11);
      end;
   until team_stats[rnd].position <> 'Keeper';

   inc(team_stats[rnd].scored);
end;


procedure switch_players(league,player : integer;
										   games : integer;
                      	 var captainOk : boolean;
							    	  character : char;
						     games_suspended : integer);

var
	player_rnd,i : integer;
	tmpstr       : string;
	next_player  : integer;
	tmpchar   	 : team_stats_type;

begin
	repeat
      player_rnd := random_limits(1,NO_OF_MAIN_TEAM);
   until team_stats[player_rnd].ch = '0';

	with team_stats[player_rnd] do
   begin
		ch := character;
      endwk := games+games_suspended;
   end;

   for i := 1 to playerTotal do
   	if (team_stats[i].ch = '0') then
         next_player := i;

   if team_stats[player_rnd].captain then
   begin
   	team_stats[player_rnd].captain := false;
      captainOk := true;
   end;

   team_stats[player_rnd].games_off := games_suspended+1;

   with teams[league,player] do
   begin
   	tmpstr := players[player_rnd];
      players[player_rnd] := players[next_player];
      players[next_player] := tmpstr;
   end;

   tmpchar[player_rnd] := team_stats[player_rnd];
   team_stats[player_rnd] := team_stats[next_player];
   team_stats[next_player] := tmpchar[player_rnd];
end;


procedure play_match(homeTeam,awayTeam : integer;
			  			 league,player,games : integer;
					  			 var captainOk : boolean;
			  			 var games_suspended : integer);

var
	time,freekick_rnd,team_rnd,wait : integer;
	tmp_rnd,penalty_rnd,match_rnd   : integer;

	rnd,i   : integer;
   speedNo : word;
   ch      : char;

begin
   textcolor(black);
   for i := 1 to 2 do
   with stats[i] do
   begin
      on_target  := 0;
      off_target := 0;
      penalty    := 0;
      injured    := 0;
		sent_off   := 0;
   end;

   teams[league,homeTeam].scores := 0;
   teams[league,awayTeam].scores := 0;

   case options.speed of
   	1 : speedNo := speed[6];
      2 : speedNo := speed[7];
      3 : speedNo := speed[8];
   end;

   for time := 1 to FULL_TIME+random_limits(1,INJURY_TIME) do
   begin
      clrwin(36,10,44,10);
   	writexy(conv(time)+' mins',10,c1);

     	writecolour('#1'+teams[league,homeTeam].name+'#2'+SPC+
		conv(teams[league,homeTeam].scores)+SPC+
		conv(teams[league,awayTeam].scores)+'#1'+SPC+
		teams[league,awayTeam].name,20);

      gotoxy(1,25);
      textcolor(black);

      delay(speedNo);

      tmp_rnd := random_limits(1,2);
      case tmp_rnd of
      	1 : team_rnd := homeTeam;
         2 : team_rnd := awayTeam;
      end;

      wait := random_limits(1,GAME_WAIT);
      if wait = 1 then
      with teams[league,team_rnd] do
      begin
         match_rnd := random_limits(1,20);
         case match_rnd of
         	1..4   : rnd := 1;
            5..10  : rnd := 2;
				11..12 : rnd := 3;
            13..17 : rnd := 4;
            18     : rnd := 5;
            19     : rnd := 6;
            20     : rnd := 7;
         end;

         if rnd <> 1 then
         begin
            writexy(name+SPC+match[rnd],12,c2);
         	delay(speed[4]);
         end;

         case rnd of
         	1:
      		begin
					writexy(name+SPC+match[rnd],12,c2+blink);
            	inc(scores);
         		inc(stats[tmp_rnd].on_target);
            	if player = team_rnd then
						add_scorers;
         		delay(speed[3]);
            end;
            2 : inc(stats[tmp_rnd].off_target);
			   3 : inc(stats[tmp_rnd].on_target);
         	4 :
            begin
            	clrwin(1,12,80,12);
               freekick_rnd := random_limits(1,3);
            	case freekick_rnd of
            		1 :
						begin
							writexy(name+' scored a goal',12,c2+blink);
                     inc(scores);
               		inc(stats[tmp_rnd].on_target);
                     if player = team_rnd then
								add_scorers;
                     delay(speed[3]);
               	end;
               	2 :
						begin
							writexy(name+' just missed the post',12,c2);
                  	inc(stats[tmp_rnd].off_target);
                  	delay(speed[4]);
               	end;
               	3 :
						begin
							writexy(name+' hit the bar',12,c2);
            			inc(stats[tmp_rnd].on_target);
                  	delay(speed[4]);
            		end;
            	end;
         	end;
            5 :
				begin
            	games_suspended := random_limits(2,5);
					inc(stats[tmp_rnd].sent_off);
               if player = team_rnd then
						switch_players(

					  	league,player,games,captainOk,'s',games_suspended

						);
				end;
            6 :
         	begin
         		writexy('A player runs up to take the penalty',12,c2);
					penalty_rnd := random_limits(1,2);
            	inc(stats[tmp_rnd].penalty);
               delay(speed[4]);

            	clrwin(1,12,80,12);

            	if penalty_rnd = 1 then
            	begin
						writexy(name+' scored a goal',12,c2+blink);
            		inc(scores);
               	inc(stats[tmp_rnd].on_target);
                  if player = team_rnd then
							add_scorers;
                  delay(speed[3]);
            	end
            	else
            	begin
            		writexy(name+' have missed',12,c2);
            		inc(stats[tmp_rnd].off_target);
               	delay(speed[4]);
            	end;
      		end;
            7 :
            begin
               inc(stats[tmp_rnd].injured);
            	if player = team_rnd then
               begin
               	games_suspended := random_limits(2,7);
                  switch_players(

						league,player,games,captainOk,'i',games_suspended

						);
               end;
         	end;
      	end;
      	clrwin(22,12,58,12);
      	clrwin(22,20,58,20);
      end; { endif }

      if time = HALF_TIME then
      begin
         cls;
         writexy('Half Time',10,c2);

        	writecolour('#1'+teams[league,homeTeam].name+'#2'+SPC+
			conv(teams[league,homeTeam].scores)+SPC+
			conv(teams[league,awayTeam].scores)+'#1'+SPC+
			teams[league,awayTeam].name,12);

         textcolor(black);
         delay(speed[5]);
         cls;
      end;

      if keypressed then
      begin
         pause(ch);
      	avoid_escape(ch);
      end;
   end; { endfor }
end;


procedure display_statistics(homeTeam,awayTeam : integer;
								   		  		 league : integer);

var
	teamA,teamB 	 : integer;
	homestr,awaystr : string;
   column          : integer;
   choice,rnd      : integer;
	ch              : char;

begin
   homestr := teams[league,homeTeam].name;
   awaystr := teams[league,awayTeam].name;

   column := centre_line(homestr);
   gotoxy(column-15,10);
   textcolor(c1);
   write(homestr);

   column := centre_line(awaystr);
   gotoxy(column+15,10);
   textcolor(c1);
   write(awaystr);

	writexy('Shots on target',12,c1);
   writexy('Shots off target',13,c1);
   writexy('Penalty',14,c1);
   writexy('Injured',15,c1);
   writexy('Sent Off',16,c1);

   teamA := homeTeam-homeTeam+1;
   teamB := teamA+1;

   with stats[teamA] do
   begin
      writeto(conv(on_target),25,12,c2);
      writeto(conv(off_target),25,13,c2);
      writeto(conv(penalty),25,14,c2);
      writeto(conv(injured),25,15,c2);
      writeto(conv(sent_off),25,16,c2);
   end;
   with stats[teamB] do
   begin
      writeto(conv(on_target),55,12,c2);
      writeto(conv(off_target),55,13,c2);
      writeto(conv(penalty),55,14,c2);
      writeto(conv(injured),55,15,c2);
      writeto(conv(sent_off),55,16,c2);
   end;

   choice := random_limits(0,1);
   rnd := random_limits(1,11);

   if choice = 0 then
   	choice := homeTeam
   else
   	choice := awayTeam;

	writexy('Man of the Match',21,c2);
   writexy(teams[league,choice].players[rnd],22,c1);

	pause(ch);
end;


procedure display_scores(league,listCount : integer);

var
	teamA,teamB : integer;
	row,len,i,m : integer;
   tmpstr		: string;
	tmp         : titlesize;
	ch          : char;

begin
   cls;

   writexy('Scottish',9,c1);

   calc_league_title(league,tmp);
   writexy(tmp,10,c2);

   row := 13;

   for i := 1 to MAX_TEAMS div 2 do
   begin
      teamA := fixtureList[listCount];
   	teamB := fixtureList[listCount+1];

      tmpstr := teams[league,teamA].name;
     	len := length(tmpstr);

   	for m := len+1 to MAX_TEAM_NAME+2 do
			insert(FULL_STOP,tmpstr,m);

      gotoxy(20,row);
      textcolor(c1);
      write(tmpstr);
      textcolor(c2);
      gotoxy(37,row);
      write(conv(teams[league,teamA].scores):3);

      tmpstr := teams[league,teamB].name;
     	len := length(tmpstr);

   	for m := len+1 to MAX_TEAM_NAME+2 do
			insert(FULL_STOP,tmpstr,m);

      textcolor(c1);
      gotoxy(42,row);
      write(tmpstr);
      textcolor(c2);
		write(conv(teams[league,teamB].scores):3);

      inc(row);
      inc(listCount,2);
   end;
   pause(ch);
end;


   {  sorts a league table  }


procedure sort_table(player,league : integer);

var
	teamA,teamB,i : integer;
	tmp           : table_numbers_record;

begin
   for i := 1 to MAX_TEAMS do
   	table_numbers[i].switch := false;

   for i := 1 to MAX_TEAMS do
   begin
      table_numbers[i].pts := teams[league,i].table.pts;
      table_numbers[i].pos := i;
   end;

   table_numbers[player].switch := true;

   for teamA := 1 to MAX_TEAMS do
   	for teamB := teamA to MAX_TEAMS do
      	if table_numbers[teamA].pts < table_numbers[teamB].pts then
         begin
         	tmp := table_numbers[teamB];
            table_numbers[teamB] := table_numbers[teamA];
            table_numbers[teamA] := tmp;
         end;
end;


procedure display_table(league : integer);

var
	i,m,len,row  : integer;
	tmpnum,count : integer;
   tmpstr		 : string;
	tmp          : titlesize;
   tmpLeague	 : integer;
	ch           : char;

begin
   cls;

	calc_league_title(league,tmp);

   writexy('Scottish',6,c1);
   writexy(tmp,7,c2);

   writeto('p   w   d   l   f   a  pts',37,10,c2);

   tmpLeague := league;
   row := 12;
   count := 1;

   for i := 1 to MAX_TEAMS do
	begin
   	gotoxy(17,row);
     	textcolor(c1);

      tmpnum := table_numbers[count].pos;
     	tmpstr := teams[league,tmpnum].name;

     	len := length(tmpstr);
   	for m := len+1 to MAX_TEAM_NAME+2 do
			insert(FULL_STOP,tmpstr,m);

     	if (tmpLeague = league)
		  and (table_numbers[i].switch = true) then
			textcolor(c2)
      else
      	textcolor(c1);

   	write(tmpstr);

      with teams[league,tmpnum].table do
			write(played:4,won:4,draw:4,lost:4,f:4,a:4,pts:4);

      inc(row);
      inc(count);
   end;
   pause(ch);
end;


procedure get_home_and_away_teams(listCount,player : integer;
									  var homeTeam,awayTeam : integer);

var
	i : integer;

begin
   for i := listCount to listCount+9 do
   	if fixtureList[i] = player then
      begin
         if odd(i) then
         begin
         	awayTeam := fixtureList[i+1]; { home }
            homeTeam := player;
         end
         else
         begin
         	homeTeam := fixtureList[i-1]; { away }
         	awayTeam := player;
         end;
		end;
end;


procedure set_captain(var saveCaptain : integer;
                        var captainOk : boolean);

var
	player_rnd : integer;

begin
   repeat
   	player_rnd := random_limits(1,NO_OF_MAIN_TEAM);
   until team_stats[player_rnd].ch = '0';

   team_stats[player_rnd].captain := true;
   saveCaptain := player_rnd;
   captainOk := false;
end;


function random_position : integer;

var
	count : integer;
	m,rnd : integer;
	exit  : boolean;

begin
	count := 1;
   for m := 2 to 4 do
   	if positionCheck[m] = true then
      	inc(count);
   if count = 4 then
   	for m := 2 to 4 do
      	positionCheck[m] := false;

   repeat
   	rnd := random_limits(2,4);
      if positionCheck[rnd] = false then
      begin
      	exit := true;
      	positionCheck[rnd] := true;
      end
		else
			exit := false
   until exit;
   random_position := rnd;
end;


   {  initialise each players stats  }


procedure initialise_player(league,icounter : integer);

var
	tmp : longint;

begin
   with team_stats[icounter] do
   begin
      morale := morale_type[random_limits(1,3)];
      scored := 0;
      years := random_limits(1,7);
      games_off := 0;
      age := random_limits(MIN_AGE,MAX_AGE);
      endwk := 0;
      captain := false;
      ch := '0';

      tmp := random_limits(1,MAX_SKILL);
      skill := tmp;

   	if league = 1 then
   	begin
   		price := tmp*1000000;
   		wages := tmp*10000;
   	end else
   	begin
   		price := tmp*100000;
   		wages := tmp*100;
   	end;

   	case icounter of
      	1 : position := 'Keeper';
      2..5 : position := 'Defender';
      6..9 : position := 'Midfield';
    10..11 : position := 'Forward';
        12 : position := 'Keeper';
         else
         	position := player_position[random_position];
      end;
   end;
end;


procedure display_seasons_fixtures(player,league : integer);

const
	date_position : array[1..4] of string[2] =
  ('st','nd','rd','th');

var
	team,maxlen : integer;
   row,len,i   : integer;
   ok          : array[1..10] of boolean;
   ch          : char;

begin
   cls;
   row := 10;
   maxlen := 1;
	for i := 1 to NO_OF_FIXTURE_LIST do
   	if player = fixtureList[i] then
      begin
      	if odd(i) then   { even numbers divide by 2 }
         begin
            team := fixtureList[i+1];
         	ok[row-9] := true;
         end else
         begin
				team := fixtureList[i-1];
            ok[row-9] := false;
         end;

         with saveSettings do
         if date.wks = row-9+weekCount-1 then
      		textcolor(c2)
         else
         	textcolor(c1);

      	gotoxy(37,row);
      	write(teams[league,team].name);
      	inc(row);

         len := length(teams[league,team].name);
         if len > maxlen then
         	maxlen := len;
      end;

   with saveSettings do
   begin
   	writecolour('#1'+'Fixtures for '+'#2'+teams[league,player].name+'#1'+
		' in the season '+'#2'+conv(formatDate[1])+'/'+conv(formatDate[2]),6);

   	writecolour('#2'+conv(quarterFixture)+date_position[quarterFixture]+
	   '#1'+' quarter',23);

   	row := 10;
   	for i := weekCount to weekCount+8 do
   	begin
      	if date.wks = i then
      		textcolor(c2)
      	else
      		textcolor(c1);

   		gotoxy(29,row);
      	write('wk ',i);

         gotoxy(37+maxlen+3,row);
         if ok[row-9] then
         	write('(h)')
         else
         	write('(a)');

      	inc(row);
   	end;
   	pause(ch);
   	avoid_escape(ch);
	end;
end;


procedure swap_positions(n : integer);

begin
	case n of
   	1 : begin
      		 tmp[1] := 1; tmp[2] := 1;
             tmp[3] := 2; tmp[4] := 21;
      	 end;
      2 : begin
			    tmp[1] := def[1]; tmp[2] := def[2];
             tmp[3] := def[3]; tmp[4] := def[4];
      	 end;
      3 : begin
      	    tmp[1] := mid[1]; tmp[2] := mid[2];
             tmp[3] := mid[3]; tmp[4] := mid[4];
      	 end;
      4 : begin
      	    tmp[1] := forw[1]; tmp[2] := forw[2];
             tmp[3] := forw[3]; tmp[4] := forw[4];
      	 end;
	end;
end;


procedure select_tactics(count : integer);

var
	max : integer;

begin
	max := playerTotal;
   case count of
   	1 : { 4-4-2 }
      begin
      	def[1]  := 2;  def[2]  := 5;
         def[3]  := 6;  def[4]  := max;
         mid[1]  := 6;  mid[2]  := 9;
         mid[3]  := 10; mid[4]  := max;
			forw[1] := 10; forw[2] := 11;
         forw[3] := 12; forw[4] := max;
      end;
      2 : { 4-3-3 }
      begin
      	def[1]  := 2;  def[2]  := 5;
         def[3]  := 6;  def[4]  := max;
         mid[1]  := 6;  mid[2]  := 8;
			mid[3]  := 9;  mid[4]  := max;
         forw[1] := 9;  forw[2] := 11;
         forw[3] := 12; forw[4] := max;
      end;
      3 : { 5-3-2 }
      begin
      	def[1]  := 2;  def[2]  := 6;
         def[3]  := 7;  def[4]  := max;
         mid[1]  := 7;  mid[2]  := 9;
			mid[3]  := 10; mid[4]  := max;
         forw[1] := 10; forw[2] := 11;
         forw[3] := 12; forw[4] := max;
      end;
      4 : { 5-4-1 }
      begin
      	def[1]  := 2;  def[2]  := 6;
         def[3]  := 7;  def[4]  := max;
         mid[1]  := 7;  mid[2]  := 10;
			mid[3]  := 11; mid[4]  := max;
         forw[1] := 11; forw[2] := 11;
         forw[3] := 12; forw[4] := max;
      end;
      5 : { 3-5-2 }
      begin
      	def[1]  := 2;  def[2]  := 4;
         def[3]  := 5;  def[4]  := max;
         mid[1]  := 5;  mid[2]  := 9;
         mid[3]  := 10; mid[4]  := max;
         forw[1] := 10; forw[2] := 11;
         forw[3] := 12; forw[4] := max;
      end;
   end;
end;


procedure sort_players(league,player : integer;
						             count : integer);

var
	tmpstr  : string;
	i,m,n   : integer;
	tmpchar : team_stats_type;

begin
	select_tactics(count);
   count := 1;

   for n := 1 to 4 do
   begin
      swap_positions(n);

   	for i := tmp[1] to tmp[2] do
			if team_stats[i].position <> player_position[count] then
      		for m := tmp[3] to tmp[4] do
         		if (team_stats[m].position = player_position[count])
				  	  and (team_stats[m].ch = '0') then
            	with teams[league,player] do
            	begin
            		tmpstr := players[m];
               	players[m] := players[i];
               	players[i] := tmpstr;

               	tmpchar[m] := team_stats[m];
               	team_stats[m] := team_stats[i];
						team_stats[i] := tmpchar[m];
						break;
            	end;
      if count <= 4 then
			inc(count);
   end;
end;


function wait_reply(row : integer) : boolean;

var
	yes_colour : integer;
	no_colour  : integer;
	ok         : boolean;
	ch         : char;

begin
   ok := false;
   yes_colour := c1;
   no_colour := c2;
   repeat
		writeto('Yes',36,row,yes_colour);
      writeto('No',42,row,no_colour);

		pause(ch);
      case ch of
      	'y',LEFT_ARROW :
         begin
         	yes_colour := c2;
            no_colour := c1;
            ok := true;
         end;
         'n',RIGHT_ARROW :
         begin
         	no_colour := c2;
            yes_colour := c1;
            ok := false;
         end;
      end;
   until ch = RETURN;
   wait_reply := ok;
end;


procedure check_transactions(activity1 : string;
								  	    out,in1 : longint;
					 	      var transCount : integer);
var
	i : integer;

begin
	inc(transCount);
   if transCount > TRANS_NO then
   begin
   	with bankDetails do
   	for i := 2 to TRANS_NO do
   		transactions[i-1] := transactions[i];
      transCount := TRANS_NO;
   end;

   with bankDetails,transactions[transCount],cDate do
   begin
   	cdate    := date;
      activity := activity1;
      paidOut  := out;
      paidIn   := in1;
      cbalance := balance;
   end;
end;


procedure sell_player(player,league : integer;
							    currentrow : integer;
				  		  var saveCaptain : integer;
							     captainOk : boolean;
							      icounter : integer;
						   var transCount : integer);

var
	rLeague,rPlayer : integer;
   rTeam   			 : string;
	rPrice  			 : longint;
   rPlayers_Names  : string;
	ok,sold 			 : boolean;
   b,m 	  			 : integer;
   ch				    : char;

begin
   ok := false;
	while not ok do
   begin
		b := random_limits(1,MAX_TEAMS);
      if b = player then
   		ok := false
		else
			ok := true;
   end;

   rPlayer := b;
   rLeague := league;

   rTeam  := teams[rLeague,rPlayer].name;
   rPrice := team_stats[currentrow].price;
   rPlayers_Names := teams[league,player].players[currentrow];

   cls;
   writecolour('#2'+rTeam+'#1'+' offer '+commas(rPrice)+' for '+'#2'+
	rPlayers_Names,12);

   writexy('Do you want to sell',15,c1);
	sold := wait_reply(16);

   if sold then { the player has been sold }
   begin
      cls;
      writecolour('#2'+rPlayers_Names+'#1'+' has been sold for '+'#1'+''+
		commas(rPrice),12);

		pause(ch);

   	if team_stats[currentrow].captain then
      	set_captain(saveCaptain,captainOk);

   	inc(bankDetails.balance,rPrice);
      check_transactions('Sold',0,rPrice,transCount);

      teams[rLeague,rPlayer].players[16] := rPlayers_Names;

      with teams[league,player] do
      begin
      	for m := currentrow to MAX_PLAYERS do
         begin
         	players[m] := players[m+1];
            team_stats[m] := team_stats[m+1];
         end;
         players[MAX_PLAYERS] := EMPTY;

         with team_stats[MAX_PLAYERS] do
				initialise_player(league,icounter);
      end;
      dec(playerTotal);
	end;
end;


procedure display_captain;

begin
	textcolor(c1);
   write('(');
   textcolor(c2);
   write('c');
   textcolor(c1);
   write(')');
end;


procedure display_page(x,y : byte;
							 page : byte;
						 maxpage : byte);

begin
	gotoxy(x,y);
   textcolor(c1);
   write('Page ');
   textcolor(c2);
   write(page);
   textcolor(c1);
   write(' of ');
   textcolor(c2);
   write(maxpage);
end;


procedure display_underline(x,y : integer;
							   	 len : integer);
var
	i,colour : integer;

begin
   gotoxy(x,y);
	for i := 1 to len do
   begin
   	colour := random_limits(9,15);
      textcolor(colour);
   	write(UNDERLINE);
   end;
end;


procedure work_out_tactics_position(count : integer);

begin
	case count of
   	1 :
      	begin { 4-4-2 }
         	pos[1,1]  := 38; pos[2,1]  := 21;
            pos[1,2]  := 16; pos[2,2]  := 16;
            pos[1,3]  := 31; pos[2,3]  := 16;
            pos[1,4]  := 46; pos[2,4]  := 16;
            pos[1,5]  := 61; pos[2,5]  := 16;
            pos[1,6]  := 16; pos[2,6]  := 11;
            pos[1,7]  := 31; pos[2,7]  := 11;
            pos[1,8]  := 46; pos[2,8]  := 11;
            pos[1,9]  := 61; pos[2,9]  := 11;
            pos[1,10] := 31; pos[2,10] := 6;
            pos[1,11] := 46; pos[2,11] := 6;
         end;
      2 :
      	begin { 4-3-3 }
         	pos[1,1]  := 38; pos[2,1]  := 21;
            pos[1,2]  := 16; pos[2,2]  := 16;
            pos[1,3]  := 31; pos[2,3]  := 16;
            pos[1,4]  := 46; pos[2,4]  := 16;
            pos[1,5]  := 61; pos[2,5]  := 16;
            pos[1,6]  := 24; pos[2,6]  := 11;
            pos[1,7]  := 39; pos[2,7]  := 11;
            pos[1,8]  := 54; pos[2,8]  := 11;
            pos[1,9]  := 24; pos[2,9]  := 6;
            pos[1,10] := 39; pos[2,10] := 6;
            pos[1,11] := 54; pos[2,11] := 6;
         end;
      3 :
      	begin { 5-3-2 }
         	pos[1,1]  := 38; pos[2,1]  := 21;
            pos[1,2]  := 9;  pos[2,2]  := 14;
            pos[1,3]  := 24; pos[2,3]  := 16;
            pos[1,4]  := 39; pos[2,4]  := 16;
            pos[1,5]  := 54; pos[2,5]  := 16;
            pos[1,6]  := 68; pos[2,6]  := 14;
         	pos[1,7]  := 24; pos[2,7]  := 11;
            pos[1,8]  := 39; pos[2,8]  := 11;
            pos[1,9]  := 54; pos[2,9]  := 11;
            pos[1,10] := 31; pos[2,10] := 6;
            pos[1,11] := 46; pos[2,11] := 6;
         end;
      4 :
      	begin { 5-4-1 }
         	pos[1,1]  := 38; pos[2,1]  := 21;
            pos[1,2]  := 9;  pos[2,2]  := 14;
            pos[1,3]  := 24; pos[2,3]  := 16;
            pos[1,4]  := 39; pos[2,4]  := 16;
            pos[1,5]  := 54; pos[2,5]  := 16;
            pos[1,6]  := 69; pos[2,6]  := 14;
            pos[1,7]  := 15; pos[2,7]  := 11;
            pos[1,8]  := 30; pos[2,8]  := 11;
            pos[1,9]  := 45; pos[2,9]  := 11;
            pos[1,10] := 60; pos[2,10] := 11;
            pos[1,11] := 38; pos[2,11] := 6;
         end;
      5 :
      	begin { 3-5-2 }
         	pos[1,1]  := 38; pos[2,1]  := 21;
            pos[1,2]  := 24; pos[2,2]  := 16;
            pos[1,3]  := 39; pos[2,3]  := 16;
            pos[1,4]  := 54; pos[2,4]  := 16;
            pos[1,5]  := 7;  pos[2,5]  := 9;
            pos[1,6]  := 22; pos[2,6]  := 11;
            pos[1,7]  := 37; pos[2,7]  := 11;
            pos[1,8]  := 52; pos[2,8]  := 11;
            pos[1,9]  := 67; pos[2,9]  := 9;
            pos[1,10] := 31; pos[2,10] := 6;
            pos[1,11] := 46; pos[2,11] := 6;
         end;
   end;
end;

procedure view_tactics(league,player : integer);

var
	number,len : integer;
	tmppos,c   : integer;
	ch         : char;

begin
   cls;
   for c := 1 to NO_OF_MAIN_TEAM do
   with teams[league,player] do
   begin
      len := (length(players[c]) div 2);
   	gotoxy((pos[1,c])+len-1,pos[2,c]);
      textcolor(c2);
      write(c);

      if c <= 9 then
      	if odd(length(players[c])) then
      		number := -1
      	else
      		number := 0
      else
      	number := 0;

      gotoxy(pos[1,c]+number,(pos[2,c])+1);
      textcolor(c1);
      write(players[c]);

   	if team_stats[c].captain then
      begin
         if c >= 10 then
         	tmppos := 1
         else
         	tmppos := 2;

         gotoxy(pos[1,c]+len-tmppos,pos[2,c]+2);
      	display_captain;
      end;
   end;
   pause(ch);
	avoid_escape(ch);
end;


procedure display_player_details(currentrow : integer;
									   league,player : integer;
											        ok : boolean);
var
	page : byte;

begin
   if ok then
   	page := 1
   else
   	page := 2;

   display_page(62,21,page,2);

   writeto('Players',64,9,c2);
   writeto('Statistics',63,10,c1);

   clrwin(58,13,79,13);
   clrwin(58,16,79,16);
   clrwin(58,19,79,19);

	with team_stats[currentrow] do
   if ok then
   begin
      writeto('Name',58,12,c2);
      writeto('Skill',71,12,c2);
      writeto('Position',58,15,c2);
      writeto('Morale',71,15,c2);
      writeto('Price',58,18,c2);
      writeto('Contract',71,18,c2);

      writeto(teams[league,player].players[currentrow],58,13,c1);
      writeto(position,58,16,c1);
      writeto(''+commas(price),58,19,c1);
      writeto(conv(skill),71,13,c1);
      writeto(morale,71,16,c1);
      writeto(conv(years)+' year(s)',71,19,c1);
   end else
   begin
      writeto('Wages',58,12,c2);
      writeto('Age',71,12,c2);
      writeto('Scored',58,15,c2);
      writeto('Games Off',71,15,c2);
      writeto('Bookings',58,18,c2);
      writeto('Sent Off',71,18,c2);

      writeto(''+commas(wages),58,13,c1);
      writeto(conv(scored),58,16,c1);
      writeto(conv(age),71,13,c1);
      writeto(conv(games_off)+' week(s)',71,16,c1);
      writeto('0',58,19,c1);
      writeto('0',71,19,c1);
	end;
   gotoxy(1,25);
   textcolor(black);
end;


procedure display_options(count : integer);

const
	tactics : array[1..5] of string[5] =
  ('4-4-2','4-3-3','5-3-2','5-4-1','3-5-2');

begin
   writeto('Press the required',8,9,c1);
   writeto('Alt',14,10,c2);
   writeto('Key',18,10,c1);

   writeto('Alt+S',4,12,c2);
   writeto('Alt+C',4,13,c2);
   writeto('Alt+F',4,14,c2);
   writeto('Alt+H',4,16,c2);
   writeto('Alt+I',4,17,c2);
   writeto('Alt+V',4,19,c2);
	writeto('Alt+T',4,20,c2);

   writeto('-  Sell Player',11,12,c1);
   writeto('-  Select Captain',11,13,c1);
   writeto('-  View Fixtures',11,14,c1);
   writeto('-  Display Help',11,16,c1);
   writeto('-  View Information',11,17,c1);
   writeto('-  View Tactics',11,19,c1);
   writeto('-  Select Tactics',11,20,c1);

	writeto(tactics[count],18,21,c2);
end;


procedure help_page;

var
	row,i  : integer;
   helpF  : text;
   tmpstr : string[80];
   page   : integer;
   count  : integer;
   ch     : char;

begin
	cls;
   writexy('Help Page',2,c2);
   writexy('For View Squad',3,c2);

   set_file(helpF,'reset',path+Fname[3]);

   row := 6;
   page := 1;
   count := 1;
   for i := 1 to NO_OF_LINES do
   begin
   	readln(helpF,tmpstr);

      if ((page = 1) and (i in [1,4,8,11,15]))
		  or ((page = 2) and (i in [19])) then
      begin
      	gotoxy(1,row);
      	textcolor(c2);
         write(count,FULL_STOP);
         inc(count);
   	end;

      gotoxy(4,row);
      textcolor(c1);
      write(tmpstr);

      if page = 1 then
      begin
      	colourletter(25,20,25,20,c1,c2,'i');
   		colourletter(30,20,30,20,c1,c2,'s');
      	gotoxy(1,25);
      end;

      if row = 23 then
      begin
         pause(ch);
         clrwin(1,6,80,24);
         inc(page);
         row := 6;
      end else
      	inc(row);

		display_page(34,25,page,2);
   end;

	set_file(helpF,'close',EMPTY);

   gotoxy(1,25);
   pause(ch);

	avoid_escape(ch);
end;


procedure information(league,player : integer;
							    leaguesWon : integer);

var
	ch     : char;
   tmpstr : string[10];
   tmp    : titlesize;
   lgepos : byte;
	i 		 : byte;

begin
   calc_league_title(league,tmp);

   with savedSponsor do
   if check then
   	tmpstr := savedname
   else
   	tmpstr := 'None';

	lgepos := 0;
   for i := 1 to MAX_TEAMS do
   	if table_numbers[i].switch = true then
      	lgepos := i;

	cls;
   writexy('Manager''s',6,c2);
	writexy('Information',7,c1);
   writeto('Manager',26,10,c1);
   writeto('Team',47,10,c1);
   writeto('Balance',26,13,c1);
   writeto('Loan',47,13,c1);
	writeto('League Pos',26,16,c1);
   writeto('League',47,16,c1);
   writeto('Leagues Won',26,19,c1);
   writeto('Sponsor',47,19,c1);

   with teams[league,player],bankDetails,date do
   begin
   	writeto(manager,26,11,c2);
      writeto(''+commas(balance),26,14,c2);
		writeto(conv(lgepos),26,17,c2);
   	writeto(conv(leaguesWon),26,20,c2);
      writeto(name,47,11,c2);
   	writeto(''+commas(loan),47,14,c2);
      writeto(tmp,47,17,c2);
      writeto(tmpstr,47,20,c2);
      writeto('p   w   d   l   f   a  pts',27,23,c2);
      gotoxy(24,24);
      textcolor(c1);
      with teams[league,player].table do
			write(played:4,won:4,draw:4,lost:4,f:4,a:4,pts:4);
   end;
   pause(ch);
end;


procedure select_captain(currentrow : integer;
						  var saveCaptain : integer);

var
	ch : char;
   i  : byte;

begin
	if currentrow > 11 then
   begin
   	cls;
      writexy('The captain must be in the team',12,c1);
      pause(ch);
      avoid_escape(ch);
   end else
   begin
      if team_stats[currentrow].ch = '0' then
      begin
      	for i := 1 to MAX_PLAYERS do
				team_stats[i].captain := false;

         team_stats[currentrow].captain := true;
         saveCaptain := currentrow;
      end;
   end;
end;


procedure sell_player1(player,league : integer;
							     currentrow : integer;
				  		   var saveCaptain : integer;
							      captainOk : boolean;
							       icounter : integer;
						    var transCount : integer;
							 		    count : integer);
var
	ch : char;

begin
	if team_stats[currentrow].ch <> '0' then
   begin
   	cls;
      writexy('You can''t sell injured or suspended players',12,c1);
      pause(ch);
      avoid_escape(ch);
   end else
   if playerTotal = 17 then
   begin
   	cls;
      writexy('You have to buy a player before',12,c1);
		writexy('you can sell any more',13,c1);
      pause(ch);
      avoid_escape(ch);
   end else
   begin
		sell_player(

		player,league,currentrow,saveCaptain,
		captainOk,icounter,transCount

		);
      sort_players(league,player,count);
   end;
end;


procedure view_squad(league,player : integer;
				 		 var saveCaptain : integer;
     		      			 captainOk : boolean;
			   			    var count : integer;
						  var transCount : integer;
						      leaguesWon : integer);


procedure centre_vertically(var centreRow : integer);

begin  { when a new game centreRow is 4 (4th row) }
	centreRow := 13-(playerTotal div 2);
end;


procedure display(ch : char);

var
	centreRow : integer;
	i,len     : integer;
   svdplayer : integer;

begin
   if ch = ALT_T then
   	clrwin(36,3,51,23) {gets rid of some flickering when changing tactics}
   else
   	cls;

   centre_vertically(centreRow);

	colourchar('View Squad',1);
   display_underline(35,2,10);

   writecolour('#1'+'Press '+'#2'+'ESCAPE'+'#1'+' to exit',25);

	for i := 1 to playerTotal do
   begin
      svdplayer := i+centreRow-1;

   	textcolor(c2);
      gotoxy(33,svdplayer);
      write(i:2);

      textcolor(c1);  { prints out all the players in colour 6 }
      gotoxy(36,svdplayer);
   	write(teams[league,player].players[i]);

      if team_stats[i].captain = true then
      begin
         len := length(teams[league,player].players[i]);
         textcolor(c1);
         gotoxy(len+36+1,svdplayer);
      	display_captain;
      end;
      if team_stats[i].ch <> '0' then
      	colourletter(52,svdplayer,52,svdplayer,c1,c2,team_stats[i].ch);
   end;
end;


procedure refresh(var firsttime : boolean;
					     var saverow : integer;
						           ch : char);
begin
	display(ch);
	firsttime := false;
   saverow := 0;
end;


procedure swap_players(var firsttime : boolean;
							  league,player : integer;
                         var saverow : integer;
                      currentrow,row : integer;
                           centreRow : integer;
                     var saveCaptain : integer;
                                  ch : char);

var
	tmpchar   : team_stats_type;
   tmpstr    : string;
   svdplayer : integer;

begin
	if (team_stats[row-centreRow+1].ch = '0') then
   	if firsttime = false then { 1st time pressing the RETURN }
      begin
			gotoxy(36,row);
      	textcolor(c2);
      	write(teams[league,player].players[currentrow]);
         saverow := row;
         firsttime := true;
      end else
      begin
			svdplayer := saverow-centreRow+1;

      	if saveCaptain = svdplayer then
				saveCaptain := currentrow
         else
         if saveCaptain = currentrow then
         	saveCaptain := svdplayer;

         with teams[league,player] do
         begin
         	tmpstr := players[svdplayer];
				players[svdplayer] := players[currentrow];
            players[currentrow] := tmpstr;
         end;

         tmpchar[svdplayer] := team_stats[svdplayer];
         team_stats[svdplayer] := team_stats[currentrow];
         team_stats[currentrow] := tmpchar[svdplayer];

         refresh(firsttime,saverow,ch);
      end;
end;


var
	row,saverow   : integer;
	currentrow    : integer;
	centreRow,tmp : integer;
	firsttime,ok  : boolean;
   icounter		  : integer;
	ch            : char;

begin
   sort_players(league,player,count);
   centre_vertically(centreRow);
   display(ch);

   ok := true;
   firsttime := false;
   row := centreRow; { row is where the colour bar is on }{ the actual row }
   saverow := 0; { saverow is the row where the highlighted player is }

   repeat
      currentrow := row-centreRow+1; { currentrow starts at players[1] }

		gotoxy(36,row);
      textcolor(c2);
      write(teams[league,player].players[currentrow]);

      display_options(count);
      display_player_details(currentrow,league,player,ok);

      pause(ch);

      if (ch = LEFT_ARROW) or (ch = RIGHT_ARROW) then
			clrwin(58,12,79,19);  { gets rid of some flickering }

      if (saverow <> row) then
		begin
      	gotoxy(36,row);
      	textcolor(c1);
      	write(teams[league,player].players[currentrow]);
		end;

      textcolor(black);
		case ch of
   		UP_ARROW    : dec(row);
         DOWN_ARROW  : inc(row);
         RIGHT_ARROW : ok := false;
         LEFT_ARROW  : ok := true;
      	RETURN      : swap_players
		  					 (
		   				  firsttime,league,player,saverow,
		   				  currentrow,row,centreRow,saveCaptain,ch
		  					 );
         ALT_S :
         begin
         	sell_player1
			  (
				player,league,currentrow,saveCaptain,
				captainOk,icounter,transCount,count
			  );
            refresh(firsttime,saverow,ch);
   			centre_vertically(centreRow);
         end;
         ALT_C :
         begin
         	select_captain(currentrow,saveCaptain);
         	refresh(firsttime,saverow,ch);
			end;
         ALT_F :
			begin
				display_seasons_fixtures(player,league);
            refresh(firsttime,saverow,ch);
         end;
         ALT_T :
         begin
         	inc(count);
          	if count > 5 then
            	count := 1;
            sort_players(league,player,count);
          	refresh(firsttime,saverow,ch);
         end;
         ALT_V :
         begin
            sort_players(league,player,count);
            work_out_tactics_position(count);
            view_tactics(league,player);
          	refresh(firsttime,saverow,ch);
         end;
         ALT_H :
         begin
          	help_page;
          	refresh(firsttime,saverow,ch);
      	end;
         ALT_I :
         begin
         	information(league,player,leaguesWon);
            refresh(firsttime,saverow,ch);
         end;
      end; { endcase }

      if not odd(playerTotal) then  { even numbers divide by 2 }
      	tmp := 1
      else
      	tmp := 0;

      if row < centreRow then
      	row := 25-(centreRow+tmp)+1
      else
      if row > 25-(centreRow+tmp)+1 then
      	row := centreRow;

   until ch = ESCAPE;
   textcolor(black);
end;


procedure show_teams(league,player : integer;
   		    var homeTeam,awayTeam : integer;
   			 		 var saveCaptain : integer;
                 			 captainOk : boolean;
			      			 var count : integer;
						  var transCount : integer;
						      leaguesWon : integer);

var
	row,rndplayer : integer;
	i,c,m     	  : integer;
	tmpnum,len    : integer;
   tmpstr		  : string;
	ch            : char;

begin
	tmpstr := referee[random_limits(1,REFEREE_MAX)];
   rndplayer := random_limits(1,NO_OF_MAIN_TEAM);

   if player = homeTeam then
   	c := homeTeam-homeTeam+1
   else
   if player = awayTeam then
   	c := awayTeam-awayTeam+2;

   textcolor(black);
   tmpnum := homeTeam;
   for i := 1 to 2 do
	begin
      cls;
      writexy(teams[league,tmpnum].name,6,c2);

      writecolour('#1'+'Press '+'#2'+'ESCAPE'+'#1'+' to view squad',25);
      writecolour('#2'+'Referee'+SPC+'#1'+tmpstr,22);

      writeto('Manager',45,9,c2);
      writeto(teams[league,tmpnum].manager,45,10,c1);

   	textcolor(c1);
		row := 9;
   	for m := 1 to NO_OF_MAIN_TEAM do
   	begin
      	textcolor(c2);
      	gotoxy(26,row);
      	write(m:2);
      	textcolor(c1);
      	gotoxy(29,row);
      	write(teams[league,tmpnum].players[m]);

         if i = c then
         begin
         	if team_stats[m].captain then
         	begin
         		len := length(teams[league,tmpnum].players[m]);
         		gotoxy(29+len+1,row);
            	display_captain;
         	end;
         end else
         begin
            len := length(teams[league,tmpnum].players[rndplayer]);
         	gotoxy(29+len+1,rndplayer+8);
         	display_captain;
         end;
      	inc(row);
   	end;

      writeto('Substitutes',45,13,c2);

   	row := 15;
   	for m := 12 to 16 do
   	begin
      	textcolor(c2);
      	gotoxy(45,row);
      	write(m);
      	textcolor(c1);
   		gotoxy(48,row);
      	write(teams[league,tmpnum].players[m]);
      	inc(row);
   	end;

      tmpnum := awayTeam;
   	pause(ch);

      if ch = ESCAPE then
      begin
      	if i = 1 then
			begin
				i := 0;
            tmpnum := homeTeam;
         end
         else
         if i = 2 then
         begin
         	i := 1;
            tmpnum := awayTeam;
         end;
         view_squad(

			league,tmpnum,saveCaptain,captainOk,
			count,transCount,leaguesWon

			);
      end;
	end;
	textcolor(black);
end;

{
     calculates a football divisions table
     In: league,listCount
}

procedure work_out_table(L : integer;
					  listCount : integer);

var
	teamA,teamB 	 : integer;
   scoresA,scoresB : integer;
	i,m 				 : integer;

begin
   cls;
  	for i := 1 to MAX_TEAMS do
     	inc(teams[L,i].table.played);

	for m := 1 to MAX_TEAMS div 2 do
   begin
      teamA := fixtureList[listCount];
      teamB := fixtureList[listCount+1];

      scoresA := teams[L,teamA].scores;
      scoresB := teams[L,teamB].scores;

  		if scoresA = scoresB then
		begin
			inc(teams[L,teamA].table.draw);
			inc(teams[L,teamB].table.draw);
     		inc(teams[L,teamA].table.pts);
     		inc(teams[L,teamB].table.pts);
  		end
  			else
  		if scoresA > scoresB then
		begin
			inc(teams[L,teamA].table.won);
     		inc(teams[L,teamB].table.lost);
     		inc(teams[L,teamA].table.pts, 3);
		end
			else
  		begin
			inc(teams[L,teamB].table.won);
     		inc(teams[L,teamA].table.lost);
     		inc(teams[L,teamB].table.pts, 3);
  		end;

     	inc(teams[L,teamA].table.f, scoresA);
  		inc(teams[L,teamA].table.a, scoresB);
  		inc(teams[L,teamB].table.f, scoresB);
  		inc(teams[L,teamB].table.a, scoresA);

   	inc(listCount,2);
  	end;
end;

{
    calculates score for one game
    In: teamA,teamB,league
}

procedure calc_scores(teamA,teamB : integer;
						         league : integer);

var
	time,freekick_rnd,team_rnd : integer;
	wait,penalty_rnd,rnd       : integer;

begin
   teams[league,teamA].scores := 0;
   teams[league,teamB].scores := 0;

   for time := 1 to FULL_TIME+random_limits(1,INJURY_TIME) do
   begin
      team_rnd := random_limits(1,2);
      case team_rnd of
      	1 : team_rnd := teamA;
         2 : team_rnd := teamB;
      end;

      wait := random_limits(1,GAME_WAIT);
      if wait = 1 then
      with teams[league,team_rnd] do
      begin
      	rnd := random_limits(1,MATCH_COMMENTARY_NO);
         case rnd of
         	1 : inc(scores);
            4 :
            begin
            	freekick_rnd := random_limits(1,3);
               if freekick_rnd = 1 then
						inc(scores);
         	end;
         	6 :
            begin
            	penalty_rnd :=random_limits(1,2);
   	         if penalty_rnd = 1 then
						inc(scores);
      		end;
      	end;
   	end;
	end;
end;


procedure calc_league_scores(listCount : integer);

var
	teamA,teamB : integer;
	league,m    : integer;
	tmpnum      : integer;

begin
	tmpnum := listCount;
	for league := 1 to 4 do
   begin
   	for m := 1 to MAX_TEAMS div 2 do
      begin
      	teamA := fixtureList[listCount];
         teamB := fixtureList[listCount+1];
         calc_scores(teamA,teamB,league);
         inc(listCount,2);
      end;
      listCount := tmpnum;
   end;
end;


procedure work_out_all_tables(listCount : integer);

var
	tmpnum,L : integer;

begin
   tmpnum := listCount;
	for L := 1 to 4 do
   begin
   	work_out_table(L,listCount);
   	listCount := tmpnum;
   end;
end;


procedure load_details;

var
   D		: text;
	e,m,i : integer;

begin
   set_file(D,'reset',path+Fname[2]);

   for e := 1 to 4 do
   	for m := 1 to MAX_TEAMS do
      	readln(D,teams[e,m].name);
   readln(D);

   for e := 1 to 4 do
   	for m := 1 to MAX_TEAMS do
		begin
      	with teams[e,m] do
			for i := 1 to {MAX_PLAYERS-2}19 do
				readln(D,players[i]);
   		readln(D);
   	end;

   for m := 1 to NO_OF_TRANSFER_LIST do { don't need this }
   with transfer_list[m] do   { there is a good chance there will be bugs }
	begin                      { if you take this out }
		readln(D,Tname);
      readln(D,Tprice);
      readln(D,Tpresent_team);
      readln(D,Tposition);
      readln(D,Tskill);
      readln(D);
   end;

   for e := 1 to 4 do
   	for m := 1 to MAX_TEAMS do
         with teams[e,m] do
      	readln(D,manager);

   readln(D);
   for i := 1 to SPONSOR_MAX do
   with sponsor[i] do
   	readln(D,name);

   readln(D);
   for i := 1 to REFEREE_MAX do
   	readln(D,referee[i]);

	set_file(D,'close',EMPTY);
end;

{
	use the decimal to work out interest
 	ex. 10,000,000

 	9.99% or 0.0999    19.99% or 0.1999
 	999,000 p/year     1,999,000 p/year

 	0.83% or 0.0083    1.66% or 0.0166
 	83,000 p/month     166,000 p/month
}

function work_out_interest(interest_rates : real) : real;

begin
   work_out_interest := (interest_rates / 12) / 100;
end;


procedure calc_interest(var transCount : integer);

var
	interest : longint;

begin
   with bankDetails do
   begin
		if loan > 0 then
      begin
			interest := round(loan * work_out_interest(9.99));
         dec(balance,interest);
         check_transactions('Interest',interest,0,transCount);
      end;

		if balance <= 0 then
			balance := 0;
   end;
end;


procedure get_loan(var transCount : integer);

var
	tmpnum   : longint;
   getLoan  : string;
	error    : integer;
   menuexit : boolean;
	ch       : char;

begin
	tmpnum := 0;
   with bankdetails do
   begin
   	repeat
         clrwin(1,10,80,24);
      	writexy('You have ',10,c1);
			writexy(''+commas(balance),11,c1);
			writexy('You owe ',13,c2);
			writexy(''+commas(loan),14,c2);
      	writexy('Type loan amount required',16,c1);
      	readxy(17,MAX_DIGITS,getLoan);

      	if (getLoan = 'cheat') or (getLoan = 'Cheat') then
      		if balance > 100000000 then
					writexy('Don''t get greedy',20,c1)
         	else
      			balance := 1000000000;

      	val(getLoan,tmpnum,error);

      	if (tmpnum < 0) or (tmpnum > max_loan)
		  		or (loan >= max_loan) and (getLoan <> EMPTY) then
      	begin
         	menuexit := false;
      		writexy('Sorry your credit limit is '+commas(max_loan),20,c1);
            writecolour('#1'+'Press '+'#2'+'SPACEBAR'+'#1'+' to re-enter',24);
         	repeat
					pause(ch);
				until ch = SPACEBAR;
      	end else
   		begin
         	menuexit := true;
      		inc(balance,tmpnum);
         	inc(loan,tmpnum);

            if tmpnum <> 0 then
               check_transactions('Loan',0,tmpnum,transCount);
      	end;
		until menuexit;

   	clrwin(1,10,80,14);

   	writexy('You have ',10,c1);
		writexy(''+commas(balance),11,c1);
		writexy('You owe ',13,c2);
		writexy(''+commas(loan),14,c2);

      display_spacebar_message(24);
   end;
end;


procedure pay_loan(var transCount : integer);

var
	tmpnum   : longint;
   payLoan  : string;
   error    : integer;
   menuexit : boolean;
   ch       : char;

begin
	tmpnum := 0;
   with bankDetails do
   begin
   	repeat
   		cls;
      	writexy('You have ',10,c1);
			writexy(''+commas(balance),11,c1);
			writexy('You owe ',13,c2);
			writexy(''+commas(loan),14,c2);

      	writexy('Type amount you want to pay off your loan',16,c1);
      	readxy(17,MAX_DIGITS,payLoan);

      	val(payLoan,tmpnum,error);
      	if (tmpnum > loan) or (tmpnum > balance)
		  		or (tmpnum < 0) then
      	begin
         	menuexit := false;
         	writexy('You don''t owe that much',20,c1);
         	writecolour('#1'+'Press '+'#2'+'SPACEBAR'+'#1'+' to re-enter',24);
      		repeat
					pause(ch);
				until ch = SPACEBAR;
			end else
      	begin
         	menuexit := true;
      		dec(balance,tmpnum);
      		dec(loan,tmpnum);

            if tmpnum <> 0 then
               check_transactions('Paid Loan',tmpnum,0,transCount);
   		end;
		until menuexit;

   	clrwin(1,10,80,14);

   	writexy('You have ',10,c1);
		writexy(''+commas(balance),11,c1);
		writexy('You owe ',13,c2);
		writexy(''+commas(loan),14,c2);

      display_spacebar_message(24);
   end;
end;


procedure single_display(text : string;
								  row : integer);

var
	len,column  : integer;
	count,char1 : integer;
	ok          : boolean;
	ch          : char;

begin
   char1 := 1;
   ok := false;
	column := centre_line(text);
   len := length(text);
   count := column;
	repeat
      colourchar('Press the spacebar to continue',24);
      gotoxy(column,row);
      textcolor(c1);
      write(text);
      gotoxy(count,12);
      textcolor(c2);
      write(text[char1]);
      gotoxy(1,25);
      textcolor(black);
      delay(speed[9]);

      if column+len-1 = count then
      	ok := true
      else
      if count = column then
      	ok := false;

      if ok then
      begin
      	dec(count);
         dec(char1);
      end else
      begin
   		inc(count);
      	inc(char1);
   	end;

      if keypressed then
      	pause(ch);
   until ch = SPACEBAR;
end;


procedure double_display(text,text1 : string);

var
	len,len1       : integer;
	column,column1 : integer;
	count,count1   : integer;
	char1,char2    : integer;
	ok,ok1         : boolean;
	ch             : char;

begin
   char1 := 1;

   len := length(text);
   len1 := length(text1);

   column := centre_line(text);
   count := column;

   column1 := centre_line(text1);
   count1 := column1+len1-1;

   char2 := len1;

	repeat
      colourchar('Press the spacebar to continue',24);
      gotoxy(column,12);
      textcolor(c1);
      write(text);
      gotoxy(column1,14);
      textcolor(c1);
      write(text1);
      gotoxy(count,12);
      textcolor(c2);
      write(text[char1]);
      gotoxy(count1,14);
      textcolor(c2);
      write(text1[char2]);
      gotoxy(1,25);
      textcolor(black);
      delay(speed[9]);

      if column+len-1 = count then
      	ok := true
      else
      if count = column then
      	ok := false;

      if column1+len1-1 = count1 then
      	ok1 := true
      else
      if count1 = column1 then
      	ok1 := false;

      if ok then
      begin
      	dec(count);
         dec(char1);
      end else
      begin
   		inc(count);
      	inc(char1);
   	end;

      if ok1 then
      begin
         dec(count1);
      	dec(char2);
      end else
      begin
			inc(count1);
         inc(char2);
   	end;

      if keypressed then
      	pause(ch);
   until ch = SPACEBAR;
end;


  { makes the transfer list for the premier league and division 1 to 3 }


procedure make_transfer_list(league,player : integer);

var
	players_picked  : array[1..4,1..MAX_TEAMS,1..MAX_PLAYERS-2] of boolean;
   lea,pla,plaName : integer;
	a,b,c,i,rnd     : integer;
   ok              : boolean;

begin
   for a := 1 to 4 do
   	for b := 1 to MAX_TEAMS do
      	for c := 1 to MAX_PLAYERS-2 do
         	players_picked[a,b,c] := false;

	for i := 1 to NO_OF_TRANSFER_LIST do
      repeat
      	plaName := random_limits(1,MAX_PLAYERS-2);

         if league = 1 then
         repeat
         	pla := random_limits(1,MAX_TEAMS);
      		lea := 1;
         until player <> pla else
         repeat
         	pla := random_limits(1,MAX_TEAMS);
      		lea := random_limits(2,4);
         until (league <> lea) and (player <> pla);

      	if players_picked[lea,pla,plaName] = false then
      	begin
				players_picked[lea,pla,plaName] := true;
            ok := true;

            with transfer_list[i] do
            begin
            	rnd  := random_limits(1,MAX_SKILL);
					Tname := teams[lea,pla].players[plaName];
               Tpresent_team := teams[lea,pla].name;
               if lea = 1 then
               	Tprice := rnd*1000000
					else
						Tprice := rnd*100000;
               Tskill := rnd;

            	case plaName of
            		1 : Tposition := 'Keeper';
               2..5 : Tposition := 'Defender';
               6..9 : Tposition := 'Midfield';
           	 10..11 : Tposition := 'Forward';
                 12 : Tposition := 'Keeper';
             		else
               		Tposition := player_position[random_position];
            	end;
            end;
      	end else
      		ok := false;
      until ok;
end;


procedure are_you_sure(var exit : boolean);

begin
   cls;
   writexy('Are you sure you want to exit',12,c1);

   if wait_reply(14) then
   begin
   	end_intro('Goodbye');
      exit := true;
   end;
end;


procedure fillCup(start,end1 : integer;
					   row,colour : integer);
var
	i : integer;

begin
   textcolor(colour);
   for i := start to end1 do
   begin
   	gotoxy(i,row);
   	write('#');
   end;
end;


procedure display_cup(var leaguesWon : integer);

var
	i,m : integer;

begin
   textcolor(black);
	cls;
   repeat
      writexy('You have won the cup',21,c2+blink);

      m := random_limits(1,7);
      i := random_limits(8,15);

      fillCup(36,44,6,m);   { top of cup    }
      fillCup(34,46,7,m);
      fillCup(31,49,8,m);

      fillCup(28,52,9,m);   { middle of cup }
		fillCup(28,32,10,i);
      fillCup(33,47,10,m);
      fillCup(48,52,10,i);

      fillCup(31,49,11,i);  { bottom of cup }
      fillCup(34,46,12,i);
      fillCup(36,44,13,i);

   	delay(speed[12]);
   until keypressed;

   inc(leaguesWon);
end;


procedure find_Hi_Low;

var
	tmp          : array[1..7] of integer;
	count,league : integer;
	i,m          : integer;

begin
	count := 1; league := 1;
   for m := 1 to 4 do
   begin
   	tmp[count] := teams[league,1].table.pts;
   	for i:= 2 to MAX_TEAMS do
   		if teams[league,i].table.pts > tmp[count] then
     			tmp[count] := teams[league,i].table.pts;

      for i := 1 to MAX_TEAMS do
      	if teams[league,i].table.pts = tmp[count] then
      		hi[league] := i;
      inc(count,2);
      inc(league);
   end;

	count := 2; league := 1;
   for m := 1 to 3 do
   begin
   	tmp[count] := teams[league,1].table.pts;
	   for i:= 2 to MAX_TEAMS do
   		if teams[league,i].table.pts < tmp[count] then
     			tmp[count] := teams[league,i].table.pts;

      for i := 1 to MAX_TEAMS do
      	if teams[league,i].table.pts = tmp[count] then
         	low[league] := i;
      inc(count,2);
      inc(league);
   end;
end;


  {
     swaps the promoted and relegated teams
     around at the end of season

	  high premier - hi[1]
	  low premier  - low[1]
	  high div 1   - hi[2]
	  low div 1    - low[2]
	  high div 2   - hi[3]
	  low div 2    - low[3]
	  high div 3   - hi[4]
  }


procedure swap_hi_low;

var
	tmpstr : teams_type;

begin
	tmpstr[2,hi[2]] := teams[2,hi[2]];
   teams[2,hi[2]]  := teams[1,low[1]];
	teams[1,low[1]] := tmpstr[2,hi[2]];

	tmpstr[3,hi[3]] := teams[3,hi[3]];
   teams[3,hi[3]]  := teams[2,low[2]]; { teams relegated from d1 }
	teams[2,low[2]] := tmpstr[3,hi[3]]; { winner promoted from d2 }

   tmpstr[4,hi[4]] := teams[4,hi[4]];
   teams[4,hi[4]]  := teams[3,low[3]];
   teams[3,low[3]] := tmpstr[4,hi[4]];
end;


procedure move_player(var league,player : integer;
								 var leaguesWon : integer);

var
	ch : char;

begin
	case league of
   	1 :
      begin
      	if player = hi[1] then
         	display_cup(leaguesWon)
         else
			if player = low[1] then  { relegated to d1 }
      	begin
         	inc(league);
            player := hi[2];
            with bankDetails do
            begin
            	balance  := 2500000;
             	max_loan := 2500000;
	            loan     := 0;
            end;
            make_transfer_list(league,player);
         end;
      end;
      2 :
      begin
      	if player = hi[2] then  { promoted to premier }
         begin
         	display_cup(leaguesWon);
         	dec(league);
            player := low[1];
            with bankDetails do
            begin
            	balance  := 20000000;
               max_loan := 10000000;
               loan     := 0;
            end;
            make_transfer_list(league,player);
         end else
         if player = low[2] then
         begin
         	inc(league);
            player := hi[3];
         end;
      end;
      3 :
      begin
      	if player = hi[3] then
         begin
         	display_cup(leaguesWon);
         	player := low[2];
            dec(league);
         end else
         if player = low[3] then
         begin
         	player := hi[4];
            inc(league);
         end;
      end;
      4 :
		begin
			if player = hi[4] then
         begin
         	display_cup(leaguesWon);
         	dec(league);
            player := low[3];
         end;
      end;
	end; { endcase }
end;


procedure display_hi_low(league : integer);

begin
	cls;
   case league of
   	1 : double_display(teams[1,hi[1]].name+' won the premier league',
			 teams[1,low[1]].name+' are relegated to division 1');

      2 : double_display(teams[2,hi[2]].name+' won division 1',
      	 teams[2,low[2]].name+' are relegated to division 2');

      3 : double_display(teams[3,hi[3]].name+' won division 2',
      	 teams[3,low[3]].name+' are relegated to division 3');

      4 : single_display(teams[4,hi[4]].name+' won division 3',12);
   end;
end;


function get_length_of_date : integer;

var
	tmp_day,tmp_month : string[2];
	len,x             : integer;

begin
   with date do
   begin
   	str(day,tmp_day);
   	str(month,tmp_month);
   end;

   len := length(tmp_day)+length(tmp_month);

   case len of
   	2 : x := 73;
      3 : x := 72;
      4 : x := 71;
   end;
   get_length_of_date := x;
end;


procedure display_date;

var
	x,x1 : integer;

begin
   gotoxy(70,1);
   write(SPC:10);
	x := get_length_of_date;
   gotoxy(x,1);
   textcolor(c1);
   with date do
   begin
		write(day);
		textcolor(c2);
		write('/');
		textcolor(c1);
		write(month);
		textcolor(c2);
		write('/');
		textcolor(c1);
		write(year);
      gotoxy(74,2);  { fixes small bug }
      write(SPC:6);
      if wks > 9 then
      	x1 := 74
      else
      	x1 := 75;
   	gotoxy(x1,2);
   	write('Week ',wks);
   end;
end;


procedure wait_menu(min,max : integer;
					  wrapAround : boolean;
						  var row : integer);

var
	ch : char;

begin
   repeat
      writeto(LeFT_POiNTeR,29,row,c2);
      writeto(RiGHT_POiNTer,51,row,c2);

		pause(ch);

      writeto(SPC,29,row,black);
      writeto(SPC,51,row,black);

   	case ch of
	  		UP_ARROW   : dec(row);
     		DOWN_ARROW : inc(row);
   	end;

      if ch = '1' then
   		options.match := 2;

   	if wrapAround then
   	begin
   		if row < min then
				row := max;
   		if row > max then
				row := min;
   	end
   	else
   	begin
   		if row < min then
				row := min;
   		if row > max then
				row := max;
   	end;
   until ch = RETURN;
end;


function intro_menu : boolean;

var
	row : integer;

begin
	cls;
   row := 12;
   writexy('New Game',12,c1);
   writexy('Restore Game',13,c1);
   wait_menu(12,13,false,row);
   case row-12 of
   	0 : intro_menu := false;
   	1 : intro_menu := true;
   end;
   cls;
end;


procedure main_menu(var row : integer);

const
	menu_items : array[1..MENU_NUMBER] of string[15] =
  ('Play Match',
	'Fitness',
	'Loan',
	'View Squad',
	'Transfer Market',
	'Sponsors',
	'Options',
	'Save Game',
	'Exit');

var
	i : integer;

begin
   cls;
	display_date;
   colourchar('Football Manager 2000',9);

   for i := 1 to MENU_NUMBER do
   	writexy(menu_items[i],i+11,c1);

	wait_menu(12,20,false,row);
	cls;
end;


procedure loan_menu(var row : integer);

begin
   cls;
   row := 12;
   writexy('Obtain Loan',12,c1);
   writexy('Pay Loan',13,c1);
   wait_menu(12,13,false,row);
   cls;
end;


function team_menu(var choice : boolean) : integer;

var
	i,c,m,y     : integer;
	row,min,max : integer;
	exit 	     : boolean;

begin
   row := 3;
   exit := false;
   min := 1; max := 2;
   repeat
   	cls;
   	writexy('Select your team',1,c2);
   	writexy('More',3,c2);
   	y := 4;
      choice := false;
   	for c := min to max do
   		for i := 1 to MAX_TEAMS do
      	begin
				writexy(teams[c,i].name,y,c1);
         	inc(y);
      	end;
   	wait_menu(3,23,true,row);
		if row <> 3 then
      begin
         exit := true;
      	break;
      end
      else
   	begin
   		cls;
         inc(min,2); inc(max,2);
      	writexy('Select your team',1,c2);
      	writexy('Back',3,c2);
      	y := 4;
      	choice := true;
      	for c := min to max do
      		for i := 1 to MAX_TEAMS do
         	begin
					writexy(teams[c,i].name,y,c1);
            	inc(y);
         	end;
      	wait_menu(3,23,true,row);
         if row <> 3 then
         begin
         	exit := true;
         	break;
         end;
      	dec(min,2); dec(max,2);
   	end;
	until exit;
   team_menu := row-3;
   cls;
end;


function choose_league(var player : integer;
			  			         choice : boolean) : integer;

var
	tLeague : integer;

begin
   if choice = false then
   begin
   	if (player > 10) then
   	begin
   		dec(player,10);
      	tLeague := 2;
   	end else
   		tLeague := 1
   end else
   if choice = true then
   begin
   	if (player > 10) then
      begin
      	dec(player,10);
         tLeague := 4;
      end else
      	tLeague := 3;
   end;
	choose_league := tLeague;
end;


function random_numbers : integer;

var
	ok  : boolean;
	rnd : integer;

begin
	repeat
   	rnd := random_limits(1,NO_OF_CHECKS);
      if check[rnd] = false then
      begin
      	ok := true;
      	check[rnd] := true;
      end
		else
			ok := false
   until ok;
   random_numbers := rnd;
end;


procedure transfer_save_page(row,page : integer);

begin
	with save_page do
   begin
   	sRow 	:= row;
   	sPage := page;
   end;
end;


procedure change_contract(player_selected,league : integer);

const
	extra1 : array[1..3] of string[9] =
  ('Car','House','Car+House');

var
	row,count : integer;
	wagenum,i : integer;
	colour    : array[1..4] of integer;
	ch        : char;

begin
   if exit_intro then
   	exit;

   count := 1;
   contract.no_of_years := 3;
   row := 18;

   with transfer_list[player_selected],contract do
   if league = 1 then
   begin
   	wage := Tprice div 100;
      wagenum := 1000;
   end
   else
   begin
   	wage := Tprice div 1000;
      wagenum := 100;
   end;

	cls;
   writexy('Change contract',9,c2);

   writeto('Years',34,12,c1);
   writeto('Wage',34,14,c1);
   writeto('Extra',34,16,c1);

   with contract do
   repeat
      for i := 1 to 4 do
      	colour[i] := c1;

   	case row of
      	12 : colour[1] := c2;
         14 : colour[2] := c2;
         16 : colour[3] := c2;
         18 : colour[4] := c2;
      end;

      clrwin(43,12,55,16);

      writeto(conv(no_of_years),43,12,colour[1]);
      writeto(''+commas(wage),43,14,colour[2]);
      writeto(extra1[count],43,16,colour[3]);

      writexy('Continue',19,colour[4]);

      gotoxy(1,25);
   	pause(ch);
   	case ch of
      	LEFT_ARROW :
				case row of
					12 : dec(no_of_years);
               14 : dec(wage,wagenum);
               16 : dec(count);
         	end;
         RIGHT_ARROW :
				case row of
					12 : inc(no_of_years);
               14 : inc(wage,wagenum);
               16 : inc(count);
            end;
         CTRL_LEFT  : if row = 14 then dec(wage,wagenum*5);
         CTRL_RIGHT : if row = 14 then inc(wage,wagenum*5);
         UP_ARROW   : dec(row,2);
         DOWN_ARROW : inc(row,2);
         ESCAPE	  :
				begin
         		exit_intro := true;
					exit;
         	end;
   	end;

      limits(no_of_years,1,7);
      limits(count,1,3);
		limits(row,12,18);

      if league = 1 then
      begin
      	if wage <= 10000 then
				wage := 10000
      	else
      	if wage >= 100000 then
				wage := 100000;
      end else
      begin
      	if wage <= 100 then
         	wage := 100
         else
         if wage >= 1500 then
         	wage := 1500;
      end;
   until (row = 18) and (ch = RETURN);
end;


procedure ask_price(player_selected : integer;
				    		 league,player : integer;
							var transCount : integer);

var
	tmpstr         : string;
	level,maxlevel : longint;
	error,errormsg : integer;
   checktotal,i	: integer;
   amount         : longint;
	ch             : char;

begin
   if exit_intro then
   	exit;

   with transfer_list[player_selected] do
   begin
      cls;
      writexy('Name',9,c1);
      writexy(Tname,10,c2);
      writexy('Price',11,c1);
      writexy(''+commas(Tprice),12,c2);
      writexy('Position',13,c1);
      writexy(Tposition,14,c2);
      writexy('Skill',15,c1);
      writexy(conv(Tskill),16,c2);

	   writexy('Type your bid',19,c1);
   	readxy(20,MAX_DIGITS,tmpstr);

      val(tmpstr,amount,error);

   	level    := Tprice div 2;
   	maxlevel := Tprice * 2;

      { test to see if no more players can go into the transfer Market }

      checktotal := 0;
      for i := 1 to NO_OF_CHECKS do
      	if check[i] = TRUE then
         	inc(checktotal);

      if checktotal = NO_OF_CHECKS then
      	errormsg := 1
      else
      if playerTotal = 21 then
      	errormsg := 2
      else
      if bankDetails.balance < amount then
      	errormsg := 3
      else
      if amount > Tprice+maxlevel then
      	errormsg := 4
      else
      if amount < Tprice-level then
      	errormsg := 5
      else
			errormsg := 0;

      cls;
      case errormsg of
			1: writexy('No more players can be bought',12,c1);
    		2: writexy('Your squad is full, you''ll have to sell a player',12,c1);
      	3: writexy('You haven''t got enough money',12,c1);
    		4: writexy('The player is not worth that price',12,c1);
     		5: writexy('Your bid has not been accepted',12,c1);
      end;

      if errormsg = 0 then
      begin
      	writecolour('#2'+Tname+'#1'+' has joined '+
			teams[league,player].name,12);

         with bankDetails do
         	dec(balance,amount);

         inc(playerTotal);

			with team_stats[playerTotal] do
   		begin
   			teams[league,player].players[playerTotal] := Tname;
      		position	 := Tposition;
				price		 := amount;
      		skill		 := Tskill;
      		morale	 := morale_type[random_limits(1,3)];
      		years		 := contract.no_of_years;
      		wages		 := contract.wage;
      		ch			 := '0';
      		games_off := 0;
      		scored 	 := 0;
      		age 		 := random_limits(MIN_AGE,MAX_AGE);
   		end;
         check_transactions('Transfer',amount,0,transCount);
   		transfer_list[player_selected] := transfer_list[random_numbers+30];
   	end;
      pause(ch);
	end;
end;


procedure sort_transfer_list;

var
   tmpList      : transfer_list_type;
   playerCount  : integer;
   posCount,i,m : integer;

begin
   playerCount := 1;
   posCount := 1;
   for i := 1 to 4 do
   begin
   	for m := 1 to 30 do
      	if transfer_list[m].Tposition = player_position[posCount] then
         begin
         	tmpList[playerCount] := transfer_list[m];
            inc(playerCount);
         end;
      inc(posCount);
   end;

   for i := 31 to NO_OF_TRANSFER_LIST do
   	tmpList[i] := transfer_list[i];

   transfer_list := tmpList;
end;


procedure transfer_market_details;

begin
   colourchar('Transfer Market',4);
   display_underline(33,5,15);

   writeto('Name',14,8,c2);
   writeto('Price',28,8,c2);
   writeto('Team',37,8,c2);
   writeto('Position',54,8,c2);
   writeto('Skill',65,8,c2);

   writecolour('#1'+'Press '+'#2'+'ESCAPE'+'#1'+' to exit',25);
   writecolour('#1'+'Use '+'#2'+#17+#32+#16+'#1'+
	' keys to change pages',24);
end;


procedure transfer_market1(var player_selected : integer);

var
	i,colour : integer;
	row,page	: integer;
	ch			: char;

begin
	row := 10;

   with save_page do
   begin
   	row  := sRow;
		page := sPage;
   end;

	sort_transfer_list;
	transfer_market_details;

   repeat
   	display_page(34,22,round(page div 10)+1,3);

      for i := 1 to 10 do
      begin
         if row = i+9 then
         	colour := c2
         else
				colour := c1;

         with transfer_list[i+page] do
         begin
         	writeto(Tname,14,i+9,colour);
      		gotoxy(27,i+9);
      		write(Tprice:7);
         	writeto(Tpresent_team,37,i+9,colour);
         	writeto(Tposition,54,i+9,colour);
         	writeto(conv(Tskill),67,i+9,colour);
         end;
      end;

      gotoxy(1,25);
      pause(ch);

      if (ch = LEFT_ARROW) or (ch = RIGHT_ARROW) then
			clrwin(14,10,68,19);

      case ch of
         ESCAPE :
         	begin
					transfer_save_page(row,page);
               exit_intro := true;
               textcolor(black);
               exit;
            end;
         UP_ARROW :
				begin
					dec(row);
               if (row < 10) and (page <> 0) then
               begin
               	row := 19;
                  dec(page,10);
                  clrwin(14,10,68,19);
               end;
				end;
         DOWN_ARROW :
				begin
					inc(row);
               if (row > 19) and (page <> 20) then
					begin
               	row := 10;
                  inc(page,10);
                  clrwin(14,10,68,19);
               end;
				end;
         LEFT_ARROW  : if page > 0 then dec(page,10);
         RIGHT_ARROW : if page <= 20 then inc(page,10);
      end;

      limits(row,10,19);
      limits(page,0,20);

   until ch = RETURN;

   player_selected := row-9+page;
   transfer_save_page(row,page);

	textcolor(black);
end;


procedure next_week;

begin
   if date.year mod 4 = 0 then
   	days_per_month[2] := 29
	else
   	days_per_month[2] := 28;

   with date do
   begin
   	inc(day,7);
      inc(wks);
   	if day > days_per_month[month] then
   	begin
      	day := day - days_per_month[month];
   		inc(month);
         if month > 12 then
         begin
         	month := 1;
            inc(year);
         end;
   	end;
   end;
end;


procedure check_team_stats(games : integer);

var
	i : integer;

begin
   for i := 1 to playerTotal do
      with team_stats[i] do
		if games = endwk then
      begin
         ch := '0';
         endwk := 0;
         games_off := 0;
      end;

   if games = NO_OF_MATCHES then
		for i := 1 to playerTotal do
      	if team_stats[i].endwk > 0 then
         	dec(team_stats[i].endwk,NO_OF_MATCHES);

   for i := 1 to playerTotal do
      with team_stats[i] do
   		if games_off <> 0 then
      		dec(games_off);
end;


procedure new_game_initialise(league : integer;
							       var once : boolean;
				     var count,listCount : integer;
						  var fitnessTotal : integer;
							  var gameSaved : integer;
							  	   var games : integer;
							 var leaguesWon : integer);
begin
   once := true;
   count := 1;
   leaguesWon := 0;

   games := 1;
   listCount := 1;

   fitnessTotal := 0;
   gameSaved := 0;

   with saveSettings do
   begin
   	weekCount := 1;
   	quarterFixture := 1;
   end;

   with bankDetails do
   begin
      loan := 0;
      if league = 1 then
   	begin
   		balance := 20000000;
      	max_loan := 10000000;
   	end
   	else
   	begin
   		balance := 2500000;
      	max_loan := 2500000;
   	end;
   end;

   with date do
   begin
      day := random_limits(1,31);
   	month := 8;
   	year := 2000;
      wks := 1;
   end;

   with options do
   begin
   	match := {2}1;
      speed := 2;
      change := 1;
   end;

   with saveSettings do
   begin
		formatDate[1] := date.year;
   	formatDate[2] := date.year+1;
	end;

   with savedSponsor do
   begin
   	endwk := 0;
      counter := NO_OF_MATCHES;
   end;

   transfer_save_page(10,0);
end;


procedure end_of_season_initialise(var listCount : integer;
						  		 var fitnessTotal,league : integer;
							         	  var gameSaved : integer;
								    		var gameSavedOk : boolean;
													var games : integer);
var
	i : integer;

begin
	with date do
   begin
   	day := random_limits(1,31);
      month := 8;
      wks := 1;
   end;

   games := 1;

   for i := 1 to playerTotal do
   	team_stats[i].scored := 0;

   listCount := 1;
   fitnessTotal := 0;

   gameSaved := 0;
   gameSavedOk := false;

   with saveSettings do
   begin
   	weekCount := 1;
   	quarterFixture := 1;

   	inc(formatDate[1]);
   	inc(formatDate[2]);
   end;

   textcolor(black);
end;


procedure clear_leagues;

var
	m,i : integer;

begin
	for m := 1 to 4 do
		for i := 1 to MAX_TEAMS do
    		with teams[m,i].table do
    		begin
   			played := 0;
				won    := 0;
       		draw   := 0;
				lost   := 0;
       		f      := 0;
				a      := 0;
				pts    := 0;
   		end;
end;


procedure pick_player(league,player : integer);

var
	ok  : boolean;
   b   : integer;
   tmp : longint;

begin
	ok := false;
	while not ok do
   begin
		b := random_limits(1,MAX_TEAMS);
      if b = player then
   		ok := false
		else
			ok := true;
   end;

   with data do
	begin
   	tPlayer := b;
   	tLeague := league;

   	tmp := random_limits(1,MAX_SKILL);
   	tSkill := tmp;

   	if league = 1 then
   	begin
   		tPrice := tmp*1000000;
   		tWages := tmp*10000;
   	end else
   	begin
   		tPrice := tmp*100000;
   		tWages := tmp*100;
   	end;

   	tName     := random_limits(1,MAX_PLAYERS-2);  { 1 to 19 }
   	tPosition := player_position[random_limits(1,4)];
   end;
end;


procedure player_wanted(player : integer;
								league : integer;
					 var transCount : integer);

var
   tmpstr	: string;
	errormsg : integer;
	ch       : char;

begin
   pick_player(league,player);

   with data,teams[tLeague,tPlayer] do
   begin
   	cls;
      writecolour('#2'+players[tName]+'#1'+' of '+name+' wants to join '+
		teams[league,player].name+'.'+' He''s worth '+'#2'+''+commas(tPrice)+
		'#1'+',',12);

		writecolour('#1'+'his skill level is '+'#2'+conv(tSkill)+'#1'+
	   ' and his position is '+'#2'+tPosition+'#1'+'.',13);

		tmpstr := players[tName];
   end;

	writexy('Do you want to buy him',16,c1);

   if wait_reply(17) then
   begin
   	errormsg := 0;

      if playerTotal = 21 then
			errormsg := 1
      else
      if bankDetails.balance < data.tPrice then
      	errormsg := 2
      else
      	errormsg := 0;

      cls;
      case errormsg of
         1:writexy('Your squad is full, you''ll have to sell a player',12,c1);
         2:writexy('You haven''t got enough money',12,c1);
      end;

      if errormsg <> 0 then
      	pause(ch);
   end;

   if errormsg = 0 then { player bought }
   with data do
   begin
   	dec(bankDetails.balance,tPrice);
      check_transactions('Bought',tPrice,0,transCount);

      inc(playerTotal);
      teams[league,player].players[playerTotal] := tmpstr;

      writecolour('#2'+teams[tLeague,tPlayer].players[tName]+'#1'+
		' has joined '+teams[league,player].name,12);

		with team_stats[playerTotal] do
      begin
      	position := tPosition;
         price := tPrice;
         skill := tSkill;
         morale := morale_type[random_limits(1,3)];
         years := random_limits(1,7); { contract }
         wages := tWages;
         scored := 0;
         age := random_limits(MIN_AGE,MAX_AGE);
         games_off := 0;
         ch := '0';
		end;
		pause(ch);
	end;
   textcolor(black);
end;


procedure restore_game(var league,player : integer;
				   	   var count,listCount : integer;
                         		  var once : boolean;
            				 var saveCaptain : integer;
                 		   var fitnessTotal : integer;
                       		   var weekOk : boolean;
                     	   var gameSaved : integer;
                       			 var c2,c1 : integer;
                          var transCount : integer;
                      			 var games : integer;
								  var leaguesWon : integer);
var
	S 		 : text;
	i,e,m  : integer;
	tmpstr : string;

begin
   set_file(S,'reset',path+Fname[1]);

	readln(S,league);
   readln(S,player);
   readln(S,games);

   with bankDetails do
   begin
   	readln(S,balance);
	   readln(S,loan);
      readln(S,max_loan);
   end;

   readln(S,teams[league,player].manager);
   readln(S,saveCaptain);
   readln(S,count);
   readln(S,listCount);
   readln(S,fitnessTotal);
   readln(S,gameSaved);
   readln(S,c2);
   readln(S,c1);
   readln(S,playerTotal);
   readln(S,leaguesWon);

   readln(S,tmpstr);
   if tmpstr = 'FALSE' then
   	weekOk := false
   else
   	weekOk := true;

   readln(S,tmpstr);
   if tmpstr = 'FALSE' then
   	once := false
   else
   	once := true;

   with saveSettings do
   begin
   	readln(S,quarterFixture);
   	readln(S,weekCount);

   	for i := 1 to 2 do
   		readln(S,formatDate[i]);
   end;

   readln(S);
   with options do
   begin
   	readln(S,match);
      readln(S,speed);
   end;

   readln(S);
   with date do
   begin
   	readln(S,day);
      readln(S,month);
      readln(S,year);
      readln(S,wks);
   end;

   readln(S);
   for i := 1 to NO_OF_CHECKS do
   begin
   	readln(S,tmpstr);
      if tmpstr = 'FALSE' then
      	check[i] := false
      else
      	check[i] := true;
   end;

   readln(S);
   for i := 1 to NO_OF_TRANSFER_LIST do
   with transfer_list[i] do
   begin
   	readln(S,Tname);
      readln(S,Tprice);
      readln(S,Tpresent_team);
      readln(S,Tposition);
      readln(S,Tskill);
   end;

   readln(S);
   for i := 1 to 4 do
   	for m := 1 to MAX_TEAMS do
      	readln(S,teams[i,m].name);

   readln(S);
   for i := 1 to 4 do
   	for m := 1 to MAX_TEAMS do
      	readln(S,teams[i,m].manager);

   readln(S);
   for e := 1 to 4 do
   	for i := 1 to MAX_TEAMS do
      	for m := 1 to playerTotal do
         	readln(S,teams[e,i].players[m]);

   readln(S);
   for i := 1 to 4 do
   	for m := 1 to MAX_TEAMS do
      with teams[i,m].table do
      begin
      	readln(S,played);
         readln(S,won);
         readln(S,draw);
	      readln(S,lost);
   	   readln(S,f);
      	readln(S,a);
         readln(S,pts);
      end;

   readln(S);
   for i := 1 to playerTotal do
   with team_stats[i] do
   begin
      readln(S,position);
      readln(S,price);
      readln(S,skill);

      readln(S,morale);
      readln(S,scored);
      readln(S,years);

      readln(S,wages);
      readln(S,age);
      readln(S,games_off);

   	readln(S,ch);
      readln(S,endwk);
      readln(S,tmpstr);

      if tmpstr = 'FALSE' then
      	captain := false
      else
      	captain := true;
   end;

   readln(S);
   for i := 1 to NO_OF_FIXTURE_LIST do
   	readln(S,fixtureList[i]);

   readln(S);
   for i := 1 to SPONSOR_MAX do
   with sponsor[i] do
   begin
   	readln(S,name);
      readln(S,price);
   end;

   readln(S);
   with savedSponsor do
   begin
       readln(S,savedname);
       readln(S,savedprice);
       readln(S,endwk);

       readln(S,tmpstr);
       if tmpstr = 'FALSE' then
       	check := false
       else
       	check := true;

       readln(S,counter);
   end;

   readln(S);
   readln(S,transCount);

   for i := 1 to transCount do
   with bankDetails.transactions[i] do
	begin
      with cDate do
      begin
   		readln(S,day);
         readln(S,month);
         readln(S,year);
      end;
      readln(S,Activity);
      readln(S,PaidOut);
      readln(S,PaidIn);
      readln(S,cBalance);
   end;

   readln(S);
   with save_page do
   begin
   	readln(S,sRow);
   	readln(S,sPage);
   end;

   readln(S);
   for i := 1 to REFEREE_MAX do
   	readln(S,referee[i]);

	set_file(S,'close',EMPTY);
end;


procedure save_game(league,player : integer;
					   count,listCount : integer;
                             once : boolean;
           	   		 saveCaptain : integer;
                 	   fitnessTotal : integer;
                      	   weekOk : boolean;
                 	  var gameSaved : integer;
              	   var gameSavedOk : boolean;
                       	    c2,c1 : integer;
                 		  transCount : integer;
			       	      var games : integer;
							  leaguesWon : integer);
var
	S     : text;
	i,e,m : integer;
	ch    : char;

begin
   if gameSavedOk = false then
   	inc(gameSaved);

   gameSavedOk := true;

   if gameSaved > MAX_GAME_SAVED then
   begin
   	cls;
      writexy('Sorry, no more games can be saved',12,c1);
      pause(ch);
   end else
   begin
   	cls;
		writexy('Saving Game',12,c2);
   	writexy(path+Fname[1],14,c1);

      set_file(S,'rewrite',path+Fname[1]);

   	writeln(S,league);
   	writeln(S,player);
   	writeln(S,games);

      with bankDetails do
      begin
   		writeln(S,balance);
	   	writeln(S,loan);
         writeln(S,max_loan);
      end;

   	writeln(S,teams[league,player].manager);
   	writeln(S,saveCaptain);
   	writeln(S,count);
   	writeln(S,listCount);
   	writeln(S,fitnessTotal);
   	writeln(S,gameSaved);
      writeln(S,c2);
      writeln(S,c1);
      writeln(S,playerTotal);
      writeln(S,leaguesWon);
   	writeln(S,weekOk);
   	writeln(S,once);

		with saveSettings do
   	begin
	   	writeln(S,quarterFixture);
  			writeln(S,weekCount);

   		for i := 1 to 2 do
   			writeln(S,formatDate[i]);
   	end;

   	writeln(S);
   	with options do
   	begin
   		writeln(S,match);
   		writeln(S,speed);
   	end;

		writeln(S);
   	with date do
   	begin
   		writeln(S,day);
      	writeln(S,month);
      	writeln(S,year);
      	writeln(S,wks);
   	end;

   	writeln(S);
   	for i := 1 to NO_OF_CHECKS do
   		writeln(S,check[i]);

   	writeln(S);
   	for i := 1 to NO_OF_TRANSFER_LIST do
   	with transfer_list[i] do
   	begin
   		writeln(S,Tname);
      	writeln(S,Tprice);
      	writeln(S,Tpresent_team);
      	writeln(S,Tposition);
      	writeln(S,Tskill);
   	end;

   	writeln(S);
   	for i := 1 to 4 do
   		for m := 1 to MAX_TEAMS do
      		writeln(S,teams[i,m].name);

   	writeln(S);
   	for i := 1 to 4 do
			for m := 1 to MAX_TEAMS do
      		writeln(S,teams[i,m].manager);

   	writeln(S);
   	for e := 1 to 4 do
   		for i := 1 to MAX_TEAMS do
   			for m := 1 to playerTotal do
      			writeln(S,teams[e,i].players[m]);

   	writeln(S);
   	for i := 1 to 4 do
   		for m := 1 to MAX_TEAMS do
      	with teams[i,m].table do
      	begin
      		writeln(S,played);
         	writeln(S,won);
         	writeln(S,draw);
	      	writeln(S,lost);
   	   	writeln(S,f);
      		writeln(S,a);
         	writeln(S,pts);
      	end;

   	writeln(S);
   	for i := 1 to playerTotal do
   	with team_stats[i] do
   	begin
      	writeln(S,position);
      	writeln(S,price);
      	writeln(S,skill);

      	writeln(S,morale);
      	writeln(S,scored);
      	writeln(S,years);

      	writeln(S,wages);
      	writeln(S,age);
      	writeln(S,games_off);

   		writeln(S,ch);
      	writeln(S,endwk);
      	writeln(S,captain);
   	end;

   	writeln(S);
   	for i := 1 to NO_OF_FIXTURE_LIST do
   		writeln(S,fixtureList[i]);

      writeln(S);
      for i := 1 to SPONSOR_MAX do
      with sponsor[i] do
      begin
      	writeln(S,name);
         writeln(S,price);
      end;

      writeln(S);
   	with savedSponsor do
   	begin
      	writeln(S,savedname);
      	writeln(S,savedprice);
      	writeln(S,endwk);
      	writeln(S,check);
      	writeln(S,counter);
   	end;

      writeln(S);
   	writeln(S,transCount);

   	for i := 1 to transCount do
   	with bankDetails.transactions[i] do
		begin
      	with cDate do
      	begin
   			writeln(S,day);
         	writeln(S,month);
         	writeln(S,year);
      	end;
      	writeln(S,Activity);
      	writeln(S,PaidOut);
      	writeln(S,PaidIn);
      	writeln(S,cBalance);
   	end;

      writeln(S);
   	with save_page do
   	begin
   		writeln(S,sRow);
   		writeln(S,sPage);
   	end;

      writeln(S);
   	for i := 1 to REFEREE_MAX do
   		writeln(S,referee[i]);

		set_file(S,'close',EMPTY);

      writexy('Press any key to continue',21,c2);
      pause(ch);
   end;
end;


procedure change_colours_menu;

const
	colourNames : array[1..15] of string[12] =
  ('Blue','Green','Cyan','Red','Magenta','Brown','LightGray','DarkGray',
	'LightBlue','LightGreen','LightCyan','LightRed','LightMagenta','Yellow',
	'White');

var
	row,i  : integer;
   colour : array[1..4] of integer;
   ch     : char;
   tmp    : byte;

begin
	cls;
   row := 19;
   repeat
   	clrwin(32,12,48,19);

      for i := 1 to 4 do
      	colour[i] := c1;

   	case row of
      	12 : colour[1] := c2;
         15 : colour[2] := c2;
         18 : colour[3] := c2;
         19 : colour[4] := c2;
      end;

      display_date;

      writexy('Choose Colour 1',12,colour[1]);
      writexy(colourNames[c1],13,c1);

      writexy('Choose Colour 2',15,colour[2]);
      writexy(colourNames[c2],16,c2);

      writexy('Invert',18,colour[3]);
      writexy('Continue',19,colour[4]);

      pause(ch);
      case ch of
      	UP_ARROW :
            if row = 19 then
            	row := 18
            else
            	dec(row,3);
         DOWN_ARROW :
            if row = 18 then
            	row := 19
            else
            	inc(row,3);
         LEFT_ARROW :
            case row of
            	12 : dec(c1);
               15 : dec(c2);
            end;
         RIGHT_ARROW :
            case row of
            	12 : inc(c1);
               15 : inc(c2);
            end;
         RETURN :
         	if row = 18 then
            begin
                tmp := c1;
                c1 := c2;
                c2 := tmp;
            end;
      end;
      limits(row,12,19);
      limits(c2,1,15);
      limits(c1,1,15);
   until (ch = RETURN) and (row = 19);
   cls;
end;


procedure change_team_names(player : integer);

var
	tPlayer,tLeague : integer;
	tmpstr 		    : string;
   choice          : boolean;

begin
	tPlayer := team_menu(choice);
   tLeague := choose_league(player,choice);

   with teams[tLeague,tPlayer] do
   begin
   	writexy('Enter new name for '+name,12,c1);
   	readxy(13,MAX_TEAM_NAME,tmpstr);

   	if tmpstr <> EMPTY then
   		name := tmpstr;
   end;
end;


procedure change_players_names(league,player : integer);

var
	tPlayer,tLeague : integer;
   total,i,row     : integer;
   tmpstr 		    : string;
   choice          : boolean;

begin
   tPlayer := team_menu(choice);
   tLeague := choose_league(player,choice);

   if (tLeague = 1) and (tPlayer > 10) then
   begin
   	tLeague := 2;
      dec(tPlayer,10);
   end;
   if (tLeague = 3) and (tPlayer > 10 ) then
   begin
   	tLeague := 4;
      dec(tPlayer,10);
   end;

   if (league = tLeague) and (player = tPlayer) then
   	total := MAX_PLAYERS - playerTotal
   else
   	total := 2;

   with teams[tLeague,tPlayer] do
   begin
   	writexy(name,2,c2);

   	for i := 1 to MAX_PLAYERS do
   		writexy(players[i],i+3,c1);

   	row := 4;
   	wait_menu(4,24-total,true,row);

   	cls;
   	writexy('Enter new name for '+players[row-3],12,c1);
		readxy(13,MAX_PLAYER_NAME,tmpstr);

   	if tmpstr <> EMPTY then
   		players[row-3] := tmpstr;
   end;
end;


procedure change_manager(league,player : integer);

var
	tmpstr : string;

begin
   with teams[league,player] do
   begin
   	writexy('Enter new name for the manager of '+name,12,c1);
   	readxy(13,MAX_MANAGER,tmpstr);

   	if tmpstr <> EMPTY then
   		manager := tmpstr;
   end;
end;


procedure change_names_menu(league,player : integer;
									           row : integer;
										         ch : char);
begin
	if ch = RETURN then
   begin
   	cls;
      case row of
			15 :
         case options.change of
         	1 : change_team_names(player);
            2 : change_players_names(league,player);
            3 : change_manager(league,player);
         end;
         18 : change_colours_menu;
      end;
      cls;
   end;
end;


procedure options_menu(player,league : integer);

const
	skipmatch : array[1..2] of string[3] =
  ('On','Off');

	speed_types : array[1..3] of string[6] =
  ('Slow','Normal','Fast');

   change_names : array[1..3] of string[7] =
  ('Teams','Players','Manager');

var
	colour  : array[1..5] of integer;
	count,i : integer;
   row     : integer;
   ch      : char;

begin
	cls;
   row := 21;
   options.change := 1;

   with options do
   repeat
      writexy('Options Menu',7,c2);

      writeto('Match Commentary',29,11,c1);
      writeto('Match Speed',29,13,c1);
      writeto('Edit Names',29,15,c1);

   	for i := 1 to 5 do
      	colour[i] := c1;

   	case row of
      	11 : colour[1] := c2;
         13 : colour[2] := c2;
         15 : colour[3] := c2;
         18 : colour[4] := c2;
         21 : colour[5] := c2;
      end;

      clrwin(48,11,55,15);

      writeto(skipmatch[match],48,11,colour[1]);
      writeto(speed_types[speed],48,13,colour[2]);
      writeto(change_names[change],48,15,colour[3]);

      writexy('Change Colours',18,colour[4]);
      writexy('Continue',21,colour[5]);

      gotoxy(1,25);
      pause(ch);
      case ch of
      	LEFT_ARROW :
         case row of
         	11 : dec(match);
            13 : dec(speed);
            15 : dec(change);
         end;
         RIGHT_ARROW :
         case row of
         	11 : inc(match);
            13 : inc(speed);
            15 : inc(change);
         end;
			UP_ARROW :
			begin
         	if row <= 15 then
					dec(row,2)
            else
            if row >= 18 then
            	dec(row,3)
         end;
         DOWN_ARROW :
			begin
         	if row <= 13 then
            	inc(row,2)
            else
            if row >= 15 then
            	inc(row,3);
         end;
      end;

      change_names_menu(league,player,row,ch);

      limits(row,11,21);
      limits(match,1,2);
		limits(speed,1,3);
      limits(change,1,3);

	until (row = 21) and (ch = RETURN);
   textcolor(black);
end;


procedure work_out_fixture_list(player : integer);

label
	here;

var
	playedThisQuarter : array[1..MAX_TEAMS,1..MAX_TEAMS] of boolean;
	check             : array[1..MAX_TEAMS] of boolean;
	quarter           : integer;
	wks,games         : byte;
   teamA,teamB       : byte;
	a,b,i,homeCount   : byte;
   count             : byte;
   ok                : boolean;

begin
   a := 1; b := 2;
   for quarter := 1 to 1000 do
   begin
   	for wks := 1 to (MAX_TEAMS-1) do
      begin
      	for games := 1 to (MAX_TEAMS div 2) do
         begin
            count := 1;
         	repeat
               inc(count);
               if count >= MAX_CHECK then
						goto here;
            	teamA := random_limits(1,MAX_TEAMS);
               teamB := random_limits(1,MAX_TEAMS);
               ok := playedThisQuarter[teamA,teamB];
            	if (teamA = teamB) or (check[teamA]=true)
					  or (check[teamB]=true) then
               	ok := true;
            until ok=false;

				playedThisQuarter[teamA,teamB] := true;
         	playedThisQuarter[teamB,teamA] := true;

				fixtureList[a] := teamA;
         	fixtureList[b] := teamB;

            check[teamA] := true;
            check[teamB] := true;

            inc(a,2); inc(b,2);
         end; { games }
         for i := 1 to MAX_TEAMS do
   			check[i] := false;
      end; { wks }

      homeCount := 0;
      for i := 1 to NO_OF_FIXTURE_LIST do
      	if player = fixtureList[i] then
         	if odd(i) then
            	inc(homeCount);

      if (wks = 9) and
		 ((homeCount = 4) or (homeCount = 5)) then
         exit
      else
      begin
         here:
         a := 1; b := 2;
      	for teamA := 1 to MAX_TEAMS do
   			for teamB := 1 to MAX_TEAMS do
      			playedThisQuarter[teamA,teamB] := false;
         for i := 1 to MAX_TEAMS do
   			check[i] := false;
      end;
   end; { quarters }
end;


procedure fitness(games : integer;
				   var once : boolean;
		 var fitnessTotal : integer);

var
	rnd,i : integer;
	ok    : boolean;
	ch    : char;

begin
   cls;
   if once then
   begin
      case games of
   		0,5,10,15,20,25,30 : ok := true;
      	else
      		ok := false;
   	end;

      if ok then
   	begin
         inc(fitnessTotal);
			for i := 1 to playerTotal do
   		begin
         	rnd := random_limits(1,6);
      		if rnd = 1 then
      		with team_stats[i] do
         	if skill <> MAX_SKILL then
      			inc(skill);
			end;

   		colourtext('Players skill levels have been increased',12);
   	end else
      	writexy('No more fitness for this week',12,c2);
   end else
   	writexy('No more fitness for this week',12,c2);

	pause(ch);
   once := false;
end;


procedure reduce_skill_levels(fitnessTotal,league : integer);

var
	rnd,tmp,i : integer;
	ok        : boolean;

begin
   ok := true;
   case fitnessTotal of
      0 : ok := false;
   	1 : tmp := 8;
      2 : tmp := 6;
      3 : tmp := 4;
    4,5 : tmp := 3;
      6 : tmp := 2;
      7 : tmp := 1;
   end;

   if ok then
	for i := 1 to playerTotal do
   begin
      rnd := random_limits(1,tmp);
      if rnd = 1 then
      with team_stats[i] do
      begin
      	if league = 1 then
      		if skill >= 5 then
      			dec(skill,3);

      	if league <> 1 then
      		if skill >= 1 then
         		dec(skill,3);
      end;
	end;
end;


procedure reduce_contract_years(league,player : integer);

var
	i,rnd,number : integer;
	ch           : char;

begin
	for i := 1 to playerTotal do
   with team_stats[i] do
   begin
   	dec(years);
   	if years <= 0 then
      begin
      	cls;
         rnd := random_limits(1,3);
         case rnd of
         	1 : number := 3;
            2 : number := 5;
            3 : number := 7;
         end;

         writecolour('#2'+teams[league,player].players[i]+'#1'+
			' contract has ran out',12);

         writecolour('#1'+'The player wants a '+'#2'+conv(number)+' year '+
			'#1'+'contract',13);

         pause(ch);

         with team_stats[i] do
         	if (ch <> 'i') or (ch <> 's') then
         		ch := '0';

      	years := number;
      end;
   end;
end;


procedure add_injured_players(league,player : integer;
												  games : integer;
                              var captainOk : boolean);

var
	games_suspended,i : integer;
	tmpchar           : char;

begin
   for i := 1 to suspensionStore[1] do
   begin
		tmpchar := 'i';
      games_suspended := random_limits(2,7);
		switch_players(league,player,games,captainOk,tmpchar,games_suspended);
   end;

	for i := 1 to suspensionStore[2] do
   begin
		tmpchar := 's';
      games_suspended := random_limits(2,5);
      switch_players(league,player,games,captainOk,tmpchar,games_suspended);
   end;
end;


procedure calc_stats(homeTeam,awayTeam : integer;
			    			    league,player : integer);

var
	m,rnd,tmp,tmp1 : integer;
	maxscore,i     : integer;

begin
   if player = homeTeam then
   	m := homeTeam-homeTeam+1
   else
   if player = awayTeam then
   	m := awayTeam-awayTeam+2;

   for i := 1 to 2 do
   with stats[i] do
   begin
   	if i = 1 then
      begin
   		maxscore := teams[league,homeTeam].scores;
         rnd := random_limits(1,3);
			on_target := maxscore+rnd;
      end else
      begin
      	maxscore := teams[league,awayTeam].scores;
         rnd := random_limits(1,3);
         on_target := maxscore+rnd;
      end;

      off_target := random_limits(1,4);
      penalty := random_limits(0,1);

      rnd := random_limits(1,209);
      case rnd of
      	1..60    : begin tmp := 1; tmp1 := 0; end;
         61..120  : begin tmp := 0; tmp1 := 1; end;
      	121..200 : begin tmp := 0; tmp1 := 0; end;
         201..205 : begin tmp := 1; tmp1 := 1; end;
         206      : begin tmp := 2; tmp1 := 0; end;
         207      : begin tmp := 0; tmp1 := 2; end;
         208      : begin tmp := 2; tmp1 := 1; end;
         209      : begin tmp := 1; tmp1 := 2; end;
      end;

      sent_off := tmp;
		injured := tmp1;

   	if i = m then
      begin
      	suspensionStore[1] := injured;
         suspensionStore[2] := sent_off;
      end;
   end;
end;


procedure random_player(league,player : integer;
							 var player_name : string;
								var team_name : string);

var
	rLeague,rTeam : integer;
	rPlayer 		  : integer;

begin
	if league = 1 then
   	rLeague := 1
   else
		rLeague := random_limits(2,4);

   repeat
   	rTeam := random_limits(1,MAX_TEAMS);
   until (rTeam <> player);

   rPlayer := random_limits(1,MAX_PLAYERS-2);

   player_name := teams[rLeague,rTeam].players[rPlayer];
   team_name := teams[rLeague,rTeam].name;
end;


procedure increase_age(league,player : integer);

var
   player_name : string;
   team_name	: string;
   i,m         : integer;
	ch          : char;

begin
	for i := 1 to playerTotal do
   begin
   	if team_stats[i].age >= MAX_AGE then
      with teams[league,player] do
      begin
         random_player(league,player,player_name,team_name);

         cls;
         writecolour('#2'+players[i]+'#1'+' is getting to old',12);
			writexy('He has to retire',13,c1);

         writecolour('#2'+player_name+'#1'+' of '+team_name+
			' is going to swap places',15);

         pause(ch);

   		for m := i to MAX_PLAYERS do
   		begin
   			players[m] := players[m+1];
      		team_stats[m] := team_stats[m+1];
   		end;

			players[MAX_PLAYERS] := EMPTY;
   		players[playerTotal] := player_name;

         initialise_player(league,playerTotal);
      end;
      inc(team_stats[i].age);
	end;
end;


procedure exchange_fixtures(var listCount : integer;
                               var weekOk : boolean);

var
	teamA,teamB : integer;
	i,tmp       : integer;

begin
	teamA := 1;
   teamB := 2;
   for i := 1 to NO_OF_FIXTURE_LIST div 2 do
   begin
   	tmp := fixtureList[teamB];
      fixtureList[teamB] := fixtureList[teamA];
      fixtureList[teamA] := tmp;
      inc(teamA,2);
      inc(teamB,2);
   end;

   listCount := 1;
   weekOk := true;

   with saveSettings do
   begin
		inc(weekCount,9);
   	inc(quarterFixture);
   end;
end;


procedure check_numbers(var listCount : integer;
					  				var weekOk : boolean);

begin
   if date.wks in [11,20,29] then
		weekOk := false;

   if (date.wks in [10,19,28])
	  and (weekOk = false) then
   	exchange_fixtures(listCount,weekOk);
end;


procedure fitness_hint(games : integer);

var
	ok : boolean;

begin
	case games of
		5,10,15,20,25,30 : ok := true;
   else
   	ok := false;
   end;

   if ok then
   begin
   	cls;
      writexy('The team''s fitness is due',12,c1);
      writexy('Press the fitness option in the main menu',14,c2);
      display_spacebar_message(21);
   end;
end;


procedure add_injured_or_suspended(games : integer);

var
	rnd,player_rnd  : integer;
	playersNo,i,tmp : integer;
	tmpchar         : char;
   playersCheck    : array[17..19] of boolean;
   ok              : boolean;

begin
	playersNo := random_limits(1,2);
   for i := 17 to 19 do
   	playersCheck[i] := false;

   for i := 1 to playersNo do
   begin
      rnd := random_limits(1,2);
   	case rnd of
   		1 : tmpchar := 's';
      	2 : tmpchar := 'i';
   	end;

      repeat
   		player_rnd := random_limits(17,19);
         if playersCheck[player_rnd] = false then
         begin
      		playersCheck[player_rnd] := true;
            ok := true;
         end else
         	ok := false;
      until ok;

   	with team_stats[player_rnd] do
   	begin
         if tmpchar = 'i' then
         	tmp := 7
         else
         	tmp := 5;

   		ch := tmpchar;
      	games_off := random_limits(1,tmp);
      	endwk := games+games_off;
   	end;
   end;
end;


procedure calc_sponsor_details(league : integer);

var
	rndprice,i   : integer;
	rndname      : integer;
   exit         : boolean;
   sponsorCheck : array[1..SPONSOR_MAX] of boolean;
   tmpname      : array[1..SPONSOR_MAX] of string[10];

begin
   for i := 1 to SPONSOR_MAX do
   with sponsor[i] do
   begin
   	sponsorCheck[i] := false;
      tmpname[i] := name;
   end;

   for i := 1 to SPONSOR_MAX do
   begin
      exit := false;
      repeat
      	rndname := random_limits(1,SPONSOR_MAX);
         if sponsorCheck[rndname] = false then
         begin
         	sponsorCheck[rndname] := true;
            exit := true;
         end else
         	exit := false;
      until exit;

      sponsor[i].name := tmpname[rndname];
      rndprice := random_limits(3,10);

      with sponsor[i] do
      if league = 1 then
         price := rndprice * 1000000
      else
         price := rndprice * 100000;
   end;
end;


procedure check_sponsor(games,league : integer;
							 var transCount : integer);

begin
	with savedSponsor do
   begin
   	if endwk <> 0 then
      begin
         if counter = NO_OF_MATCHES then
         begin
         	savedprice := savedprice div 1000;
            with bankDetails do
				case savedprice of
            	2000 : inc(balance,20);
               1500 : inc(balance,24);
               3000 : inc(balance,12);
               1000 : inc(balance,28);
            end;
            savedprice := savedprice * 1000;
         end;
         with bankDetails do
      		inc(balance,savedprice div NO_OF_MATCHES);

         check_transactions('Sponsor',0,savedprice div NO_Of_MATCHES,transCount);

         dec(counter);
      end;
      if games = endwk then
      begin
      	endwk := 0;
         check := false;
         counter := NO_OF_MATCHES;

         cls;
         writecolour('#1'+'The sponsorship with '+'#2'+savedname+'#1'+
			' has finished',12);

         display_spacebar_message(21);
         cls;
      end;
   end;
end;


procedure display_sponsors(league,player : integer;
									     	  games : integer);

const
	position : array[1..4] of integer =
  (21,6,-9,-24);

var
	column,i : integer;
	selected : integer;
   exit,ok  : boolean;
   len 		: integer;
	ch       : char;

begin
   with savedSponsor do
	if check then
   begin
   	cls;
      writexy('You can''t select another sponsor until the current one '+
				  'finishes',12,c1);

      writecolour('#1'+'There is '+'#2'+conv(counter)+' wk(s)'+'#1'+
		' of your '+'#2'+savedname+'#1'+' sponsorship left',13);

      pause(ch);
	end else
	begin
   	cls;
      colourchar('Sponsors',6);
      display_underline(36,7,8);

      writecolour('#1'+'Press '+'#2'+'TAB'+'#1'+
		' to cycle through sponsors',20);

      writecolour('#1'+'Press '+'#2'+'ESCAPE'+'#1'+' to exit and '+'#2'+
		'RETURN'+'#1'+' to select',21);

      for i := 1 to 4 do
      with sponsor[i] do
      begin
      	textcolor(c2);
      	column := centre_line(name);
      	gotoxy(column-position[i],11);
         write(name);

         textcolor(c1);
         column := centre_line(''+commas(price));
      	gotoxy(column-position[i],12);
         write(''+commas(price));

         column := centre_line('1 year');
      	gotoxy(column-position[i],13);
         write('1 year');
      end;

      exit := false;
      column := 19;
      repeat
         writeto('*',column,15,c2);

         pause(ch);
         if ch = ESCAPE then
         begin
         	exit := true;
            ch := NULL;
            break;
         end;

         writeto(SPC,column,15,black);

         if ch = TAB then
         	inc(column,15);

         if column > 64 then
         	column := 19;
      until ch = RETURN;

      if not exit then
      begin
      	case column of
         	19 : selected := 1;
            34 : selected := 2;
            49 : selected := 3;
            64 : selected := 4;
			end;

         cls;
         writecolour('#1'+'Are you sure you want '+'#2'+
			sponsor[selected].name+'#1'+' to sponsor '+'#2'+
			teams[league,player].name,12);

         writecolour('#2'+'Caution: '+'#1'+
			'You can''t select another sponsor for 1 year',13);

         ok := wait_reply(15);

         if ok then
         begin
         	with savedSponsor do
         	begin
         		savedname := sponsor[selected].name;
            	savedprice := sponsor[selected].price;
            	check := true;
            	endwk := games+NO_OF_MATCHES;
            	if endwk > NO_OF_MATCHES then
            		dec(endwk,NO_OF_MATCHES);
				end;

         	cls;
         	with sponsor[selected] do
         	begin
         		writecolour('#2'+name+'#1'+' is sponsoring '+
					teams[league,player].name+' for '+'#2'+''+commas(price),12);

            	writecolour('#1'+'You will receive '+'#2'+''+
					commas(price div NO_OF_MATCHES)+'#1'+
					' per week for 1 year',13);
				end;
         	pause(ch);
      	end;
      end;
   end; { endif }
end;


procedure interrupt_delay(p1 : integer; var exit : boolean);

var
	i  : integer;
   ch : char;

begin
	for i := 1 to p1 div 10 do
   begin
   	delay(p1 div 5);
		if keypressed then
      begin
         pause(ch);
         if ch = RETURN then
         	ch := NULL;
         exit := true;
      end;
      if exit then
			break
   end;
end;


procedure display_tips;

var
	tips    : array[1..AMOUNT_OF_TIPS] of string[69];
	tipsRND : byte;
   tipsF   : text;
   i		  : byte;

begin
	set_file(tipsF,'reset',path+Fname[4]);

   for i := 1 to AMOUNT_OF_TIPS do
   	readln(tipsF,tips[i]);

	cls;
   tipsRnd := random_limits(1,AMOUNT_OF_TIPS);
   writexy(tips[tipsRND],14,c2);
   single_display('Tips of the Week',12);
   cls;

   set_file(tipsF,'close',EMPTY);
end;


function file_exists(filename : string) : boolean;

var
   tmpfile : text;

begin
   file_exists := false;

	assign(tmpfile,filename);
	{$I-} reset(tmpfile); {$I+}

   if IOResult = 0 then
   begin
   	file_exists := true;
   	close(tmpfile);
   end;
end;


(*procedure select_path;

var
	ch        : char;
	ok        : boolean;
   i         : byte;
   filecount : byte;

begin
	ok := false;
   repeat
   	clrscr;
   	writexy('Please enter path',12,6);
   	readxy(13,MAX_PATH,path);

		if path = EMPTY then { Pressing RETURN uses the default path }
			path := 'c:\mydocu~1\pascal\fm2000\'
      else
      	path := path+'\';

      if path = 'x' then
      begin
         textcolor(lightgray);
         clrscr;
         halt;
      end;

      filecount := 0;
      for i := 1 to FILES do
			if file_exists(path+Fname[i]) then
        		inc(filecount);

      case filecount of
         0  :
         begin
      		writexy('Fm2000 files don''t exist in this directory',19,4);
         	writexy('Press ''x'' to quit',20,6);
         end;
         1..FILES-1 :
         begin
				writexy('One of the files must be missing or corrupt',19,4);
      		writexy('You probably have to re-install Fm2000',20,6);
         end;
         FILES : ok := true;
      end;

		if filecount <> FILES then
      	pause(ch);
	until ok;
   clrscr;
end;*)


procedure display_bank_statement(transCount : integer);

var
	row,i 	  : integer;
	start,end1 : integer;
	count 	  : integer;
	ch    	  : char;

begin
   cls;
   count := 1;
   writexy('Bank Statement',5,c1);
   textcolor(c2);
   gotoxy(6,9);
   write('Date',SPC:8,'Activity',SPC:8,'Paid Out',
			 SPC:8,'Paid In',SPC:8,'Balance');

   if transCount <> 0 then
   for i := 1 to transCount do
   with bankDetails,transactions[i],cDate do
   begin
   	row := 10+count;

      textcolor(c2);
      gotoxy(3,row);
      write(count:2);

      writeto(conv(day)+'/'+conv(month)+'/'+conv(year),6,row,c1);
      writeto(activity,18,row,c1);
      writeto(''+commas(paidOut),34,row,c1);
      writeto(''+commas(paidIn),50,row,c1);
		writeto(''+commas(cbalance),65,row,c1);
      inc(count);
   end else
   begin
   	textcolor(c1);
      gotoxy(1,10);
   	write(SPC:7,'-',SPC:13,'-',SPC:15,'-',SPC:14,'-',SPC:14,'-');
   end;
   pause(ch);
end;


procedure find_league_position(var lgepos1,lgepos2 : byte;
											homeTeam,awayTeam : integer);

var
	i : byte;

begin
   lgepos1 := 0; lgepos2 := 0;
   for i := 1 to MAX_TEAMS do
   with table_numbers[i] do
   	begin
   		if pos = homeTeam then
      		lgepos1 := i;
      	if pos = awayTeam then
      		lgepos2 := i;
   	end;
end;


procedure end_of_season(var league,player : integer;
									 var listCount : integer;
                         var fitnessTotal : integer;
                            var gameSaved : integer;
                          var gameSavedOk : boolean;
								  		  var games : integer;
								   var leaguesWon : integer);

begin
	find_hi_low;
   display_hi_low(league);
   swap_hi_low;

   end_of_season_initialise
	(listCount,fitnessTotal,league,gameSaved,gameSavedOk,games);

   move_player(league,player,leaguesWon);

   reduce_contract_years(league,player);
   reduce_skill_levels(fitnessTotal,league);

   increase_age(league,player);
   clear_leagues;
end;


procedure play_match1(var listCount : integer;
								  	  player : integer;
									  league : integer;
						  var saveCaptain : integer;
				     			  var count : integer;
							var transCount : integer;
								  		games : integer;
						    var captainOk : boolean;
									var once : boolean;
								 leaguesWon : integer);

var
   games_suspended,i : integer;
   homeTeam,awayTeam : integer;
   lgepos1,lgepos2   : byte;

begin
	get_home_and_away_teams
	(listCount,player,homeTeam,awayTeam);

   show_teams
	(league,player,homeTeam,awayTeam,saveCaptain,
	 captainOk,count,transCount,leaguesWon);

	find_league_position(lgepos1,lgepos2,homeTeam,awayTeam);

   display_fixture
	(homeTeam,awayTeam,league,player,lgepos1,lgepos2);

   calc_league_scores(listCount);

   case options.match of
   	1 : play_match(homeTeam,awayTeam,league,player,games,captainOk,games_suspended);
      2 :
      begin
      	calc_scores
			(homeTeam,awayTeam,league);

         calc_stats
			(homeTeam,awayTeam,league,player);

         add_injured_players
			(league,player,games,captainOk);

         for i := 1 to teams[league,player].scores do
				add_scorers;
		end;
   end;

   if captainOk then
		set_captain(saveCaptain,captainOk);

	display_final_score(homeTeam,awayTeam,league);
   display_statistics(homeTeam,awayTeam,league);

   display_scores(league,listCount);
   work_out_all_tables(listCount);

   sort_table(player,league);
	display_table(league);

   fitness_hint(games);
   calc_interest(transCount);

   if games <> NO_OF_MATCHES then
   begin
		display_tips;
		player_wanted(player,league,transCount);
      display_bank_statement(transCount);
	end;

   next_week;
   check_team_stats(games);

   check_sponsor(games,league,transCount);
   calc_sponsor_details(league);

   inc(listCount,10);
   once := true;
end;


procedure new_game(var player,league : integer;
							 		 var once : boolean;
							 		var count : integer;
                       var listCount : integer;
                    var fitnessTotal : integer;
                       var gameSaved : integer;
           				var saveCaptain : integer;
			  			     var captainOk : boolean;
                  			var games : integer;
							 var leaguesWon : integer);

var
	manager  : string;
   choice   : boolean;
   icounter : integer;

begin
	load_details;

   writexy('Please enter your name',12,c1);
   readxy(13,MAX_MANAGER,manager);

   if manager = EMPTY then
		manager := 'Unknown';

   player := team_menu(choice);
   league := choose_league(player,choice);

   teams[league,player].manager := manager;

   new_game_initialise
	(league,once,count,listCount,fitnessTotal,gameSaved,games,leaguesWon);

   for icounter := 1 to playerTotal do
   	initialise_player(league,icounter);

   set_captain(saveCaptain,captainOk);

   add_injured_or_suspended(games);
   calc_sponsor_details(league);

   make_transfer_list(league,player);
end;


procedure find_path;

begin
{	select_path;}
{   path := 'c:\mydocu~1\pascal\fm2000\';}

   GetDir(0,path); { 0 = Current drive }
{   path := path+'\fm2000\';}

	if file_exists(path+'\fm2000\nul') then
   	path := path+'\fm2000\'
   else
   	path := path + '\';
end;


procedure introduction(var row : integer;
					 var transCount : integer;
					     var option : integer);

begin
   textmode(80);
   clrscr;
   textcolor(black);
   randomize;

{   speed_menu;}
   intro;
   find_path;

   row := 12;
   transCount := 0;
   option := 1;
end;


procedure loan_menu1(var transCount : integer;
									 var row : integer);

begin
	loan_menu(row);
	case row-11 of
   	1 : get_loan(transCount);
      2 : pay_loan(transCount);
   end;
	row := 14;
end;


procedure start_game(var option,row : integer;
                         	  player : integer;
                      var listCount : integer;
                    		 var weekOk : boolean;
				 	     		  var games : integer);

begin
	if (games = 1) and (option = 1) then
		work_out_fixture_list(player);

	main_menu(row);
   option := row-11;

   if option = 1 then
   	inc(games);

   check_numbers(listCount,weekOk);
end;


procedure transfer_market(league,player : integer;
								 var transCount : integer);

var
	player_selected : integer;

begin
   exit_intro  := false;

	transfer_market1(player_selected);
	change_contract(player_selected,league);
   ask_price(player_selected,league,player,transCount);
end;


	 (*  start of main program  *)


Var
	option,count,games,player,league,row : integer;
	saveCaptain,listCount,fitnessTotal   : integer;
	gameSaved,transCount,leaguesWon      : integer;

   once,exit,captainOk : boolean;
	weekOk,gameSavedOk  : boolean;

begin
	introduction(row,transCount,option);

	if intro_menu then
		restore_game(

	   league,player,count,listCount,once,saveCaptain,fitnessTotal,
		weekOk,gameSaved,c2,c1,transCount,games,leaguesWon

		)
   else
   	new_game(

		player,league,once,count,listCount,fitnessTotal,
		gameSaved,saveCaptain,captainOk,games,leaguesWon

		);

   repeat
      repeat
   		start_game(option,row,player,listCount,weekOk,games);
   		case option of
      		1 : play_match1(

			  	 	 listcount,player,league,saveCaptain,count,transCount,
					 games,captainOk,once,leaguesWon

				 	 );
   			2 : fitness(games,once,fitnessTotal);
         	3 : loan_menu1(transCount,row);
         	4 : view_squad(league,player,saveCaptain,captainOk,count,transCount,leaguesWon);
         	5 : transfer_market(league,player,transCount);
         	6 : display_sponsors(league,player,games);
         	7 : options_menu(player,league);
      		8 : save_game(

				 	 league,player,count,listCount,once,saveCaptain,fitnessTotal,
				 	 weekOk,gameSaved,gameSavedOk,c2,c1,transCount,games,
					 leaguesWon

				 	 );
         	9 : are_you_sure(exit);
      	end;
         if exit then
				break;
      until games = NO_OF_MATCHES+1;

      if not exit then
			end_of_season
		  (
		   league,player,listCount,fitnessTotal,
			gameSaved,gameSavedOk,games,leaguesWon
		  );
	until exit;

   textcolor(LightGray);
   clrscr;
end.


    (*  end of main program  *)