/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 5)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")

(local
mirrorOpen = 0
salt = 0
pepper = 0
doorBlocked = 1
noLeaveNote = 0
)
/******************************************************************************/
(instance public rm005 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(249 155)
					loop(3)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (mirror:init())
        (if(not(send gEgo:has(1)))
            (kit:init())
        )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState intro)
        = state intro
        (switch(state)
            (case 0 = cycles 1
            )(case 1 = cycles 10
                (if(chased)
                    (send gEgo:setMotion(MoveTo 249 145 RoomScript))
                )
            )(case 2 = cycles 10
                (if(chased)
                    Print("You locked the door behind you, but who knows how long that will keep him out.")
                    Print("I better find a way to defend myself before he gets in.")
                )
            )(case 3 = cycles 23
                (if(chased)
                    (ShakeScreen(2))
                    (if(not(pepper))
                        (if(not(salt))
                            = pepper 1
                        )(else
                            = pepper 1
                        )
                    )(else
                        (if(not(salt))
                            = salt 1
                            = pepper 0
                        )
                    )
                )
            )(case 4 = cycles 38
                (if(chased)
                    (ShakeScreen(2))
                    (if(salt)
                        (if(pepper)
                            (RoomScript:changeState(6))
                        )
                    )
                )
            )(case 5
                (RoomScript:changeState(3))
            )(case 6 = cycles 15
                (if(doorBlocked)
                    Print("He busted the door open.")
                    = doorBlocked 0
                )
                (ShakeScreen(2))
                (ProgramControl)
                (doctor:init()setCycle(Walk)setMotion(MoveTo 240 135))
                (send gEgo:setMotion(MoveTo 230 120))
            )(case 7 = cycles 4
                (send gEgo:view(102)cel(0)setCycle(End)cycleSpeed(2))
            )(case 8 = cycles 9
                (doctor:view(160)loop(1)cel(0)setCycle(End)cycleSpeed(1)ignoreActors())
            )(case 9
                (note:init())
                (PlayerControl)
                = thirdKill 1
                (send gGame:changeScore(2))
                (send gEgo:view(0)loop(2)setCycle(Walk)cycleSpeed(0))
            )(case 10 = cycles 1
                (ProgramControl)
                (send gEgo:loop(2)cel(0))
            )(case 11 = cycles 35
                (send gEgo:view(100)setCycle(End)cycleSpeed(1))
            )(case 12 = cycles 7
                Print("I'm sorry, but there's no way I'm gonna do what I think you want me to do.")
                (if(not(pottyPoint))
                    (send gGame:changeScore(1))
                    = pottyPoint 1
                )
            )(case 13 = cycles 24
                (send gEgo:view(100)cel(8)setCycle(Beg)cycleSpeed(1))
            )(case 14 = cycles 5
                (send gEgo:view(0)loop(2)cel(0)setCycle(Walk)cycleSpeed(0))
                (PlayerControl)
            )
        )
    )
 
    (method (handleEvent pEvent)
        (super:handleEvent(pEvent))

        (if(Said('look>'))
            (if(Said('/toilet'))
                Print("Now that's a good looking toilet.")
            )(if(Said('/painting'))
                Print("Calming paintings of flowers and the ocean make this a nice little bathroom.")
            )(if(Said('/mirror'))
                (if(not(mirrorOpen))
                    Print("Yes I am looking fabulous. Also I bet there are some things inside this cabinet mirror.")
                )(else
                    Print("Nothing too interesting except maybe some hairspray.")
                )
            )(if(Said('/table,kit'))
                (if(send gEgo:has(1))
                    Print("Just an empty table where a first-aid kit used to be.")
                )(else
                    Print("There is a first-aid kit on the small table.")
                )
            )(if(Said('around'))
                Print("Ah the bathroom. There is all the bathroom stuff here.")
            )(if(Said('/anyword'))
                Print("No way am I looking at something that boring.")
            )(if(Said('[ /* , !* ]'))
                Print("Ah the bathroom. There is all the bathroom stuff here.")
            )
        )

        (if(Said('open/mirror,cabinet'))
            (if(== (send gEgo: onControl()) ctlSILVER)
                (if(not(mirrorOpen))
                    = mirrorOpen 1
                    (mirror:setCycle(End))
                )(else
                    Print("It already is.")
                )
            )(else
                Print("Your arms are only so long. Go a little closer.")
            )
        )

        (if(Said('take,pick>'))
            (if(Said('/kit,medicine,bandage,box'))
                (if(<=(send gEgo:distanceTo(kit))25)
                    (if(not(send gEgo:has(1)))
                        (kit:hide())
                        (send gEgo:get(1))
                        Print("No problem.")
                        (send gGame:changeScore(2))
                        = firstKill 1
                    )(else
                        Print("You already have it stupid.")
                    )
                )(else
                    (PrintNotCloseEnough)
                )
            )(if(Said('/hairspray,spray,can,bottle'))
                (if(mirrorOpen)
                    (if(chased)
                        (if(send gEgo:has(3))
                            Print("You already have it,")
                        )(else
                            Print("You quickly take the hairspray bottle.")
                            (send gEgo:get(3))
                            (send gGame:changeScore(2))
                        )
                    )(else
                        Print("My hair looks fabulous already!")
                    )
                )(else
                    Print("It's in the cabinet, which in case you haven't noticed, is closed.")
                )
            )(if(Said('/note'))
                (if(<=(send gEgo:distanceTo(note))25)
                    (if(send gEgo:has(5))
                        Print("You already got that yo!")
                    )(else
                        Print("Got it.")
                        (note:hide())
                        (send gEgo:get(5))//note
                        (send gGame:changeScore(1))
                    )
                )
            )(if(Said('/towel'))
                Print("I really don't need that, but thanks for asking!")
            )
        )
        
        (if(Said('wash/hand'))
            Print("They are really clean thank you very much.")
        )

        (if(Said('spray,blow/fire,lighter,torch'))
            (if(send gEgo:has(2))//lighter
                (if(send gEgo:has(3))//hairspray
                    (if(not(thirdKill))
                        = chased 0
                        = doorBlocked 0
                        (RoomScript:changeState(6))
                    )(else
                        Print("You already did that!")
                    )
                )(else
                    Print("With what?")
                )
            )
        )
        (if(Said('use/hairspray'))
            Print("Be exact on what you are doing. What are you spraying with the hairspray?")
        )
        (if(Said('sit'))
            (if(not(chased))
                (if(== (send gEgo: onControl()) ctlRED)
                    (RoomScript:changeState(10))
                )(else
                    Print("You're not close enought.")
                )
            )(else
                Print("You're kidding, right?")
            )
        )
        (if(Said('go/poop'))
            (if(not(chased))
                (if(== (send gEgo: onControl()) ctlRED)
                    (RoomScript:changeState(10))
                )(else
                    Print("You're not close enought.")
                )
            )(else
                Print("You're kidding, right?")
            )
        )
        
    )
    
    (method (doit)
        (var dyingScript)
        (super:doit)
        (if(== (send gEgo: onControl()) ctlMAROON)
            (if(not(chased))
                (send gRoom:newRoom(9))
            )(else
                (if(not(noLeaveNote))
                    Print("Nah, I would rather not die right now.")
                    = noLeaveNote 1
                )
            )
        )
        (if(== (send gEgo: onControl()) ctlGREY)
            (if(mirrorOpen)
                (mirror:setCycle(Beg))
                = mirrorOpen 0
            )
        )
        (if(< (send gEgo:distanceTo(doctor)) 25)
            (if(chased)
                (if(not(doorBlocked))
                    ProgramControl()
                    = dyingScript ScriptID(DYING_SCRIPT)
                    (send dyingScript:caller()register("Get ready before he gets in next time. Use whatever you need before he comes through that door!"))
                    (send gGame:setScript(dyingScript))
                )
            )
        )
    )
)

(instance doctor of Act
    (properties
    y 160
    x 249
    view 306
    )
)
(instance mirror of Prop
    (properties
    y 84
    x 225
    view 8
    )
)
(instance kit of Prop
    (properties
    y 94
    x 300
    view 12
    )
)
(instance note of Prop
    (properties
    y 135
    x 240
    view 14
    )
)
/******************************************************************************/
